<?php

namespace Pixelboxx\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ScalingType StructType
 * Meta information extracted from the WSDL
 * - documentation: Angaben zur Skalierung, z.Zt. nur die gewünschte Größe. Wird nur XSize oder nur YSize angegeben, so wird der andere Wert unter Annahme quadratischer Pixel so berechnet, dass das Seitenverhältnis beibehalten bleibt.
 * @subpackage Structs
 */
class ScalingType extends AbstractStructBase
{
    /**
     * The XSize
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var int
     */
    public $XSize;
    /**
     * The YSize
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var int
     */
    public $YSize;
    /**
     * The Resolution
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var int
     */
    public $Resolution;
    /**
     * The behaviour
     * Meta information extracted from the WSDL
     * - default: fit
     * - use: optional
     * @var string
     */
    public $behaviour;
    /**
     * Constructor method for ScalingType
     * @uses ScalingType::setXSize()
     * @uses ScalingType::setYSize()
     * @uses ScalingType::setResolution()
     * @uses ScalingType::setBehaviour()
     * @param int $xSize
     * @param int $ySize
     * @param int $resolution
     * @param string $behaviour
     */
    public function __construct($xSize = null, $ySize = null, $resolution = null, $behaviour = 'fit')
    {
        $this
            ->setXSize($xSize)
            ->setYSize($ySize)
            ->setResolution($resolution)
            ->setBehaviour($behaviour);
    }
    /**
     * Get XSize value
     * @return int|null
     */
    public function getXSize()
    {
        return $this->XSize;
    }
    /**
     * Set XSize value
     * @param int $xSize
     * @return \Pixelboxx\StructType\ScalingType
     */
    public function setXSize($xSize = null)
    {
        // validation for constraint: int
        if (!is_null($xSize) && !(is_int($xSize) || ctype_digit($xSize))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($xSize, true), gettype($xSize)), __LINE__);
        }
        $this->XSize = $xSize;
        return $this;
    }
    /**
     * Get YSize value
     * @return int|null
     */
    public function getYSize()
    {
        return $this->YSize;
    }
    /**
     * Set YSize value
     * @param int $ySize
     * @return \Pixelboxx\StructType\ScalingType
     */
    public function setYSize($ySize = null)
    {
        // validation for constraint: int
        if (!is_null($ySize) && !(is_int($ySize) || ctype_digit($ySize))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($ySize, true), gettype($ySize)), __LINE__);
        }
        $this->YSize = $ySize;
        return $this;
    }
    /**
     * Get Resolution value
     * @return int|null
     */
    public function getResolution()
    {
        return $this->Resolution;
    }
    /**
     * Set Resolution value
     * @param int $resolution
     * @return \Pixelboxx\StructType\ScalingType
     */
    public function setResolution($resolution = null)
    {
        // validation for constraint: int
        if (!is_null($resolution) && !(is_int($resolution) || ctype_digit($resolution))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($resolution, true), gettype($resolution)), __LINE__);
        }
        $this->Resolution = $resolution;
        return $this;
    }
    /**
     * Get behaviour value
     * @return string|null
     */
    public function getBehaviour()
    {
        return $this->behaviour;
    }
    /**
     * Set behaviour value
     * @uses \Pixelboxx\EnumType\ScalingBehaviourType::valueIsValid()
     * @uses \Pixelboxx\EnumType\ScalingBehaviourType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $behaviour
     * @return \Pixelboxx\StructType\ScalingType
     */
    public function setBehaviour($behaviour = 'fit')
    {
        // validation for constraint: enumeration
        if (!\Pixelboxx\EnumType\ScalingBehaviourType::valueIsValid($behaviour)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \Pixelboxx\EnumType\ScalingBehaviourType', is_array($behaviour) ? implode(', ', $behaviour) : var_export($behaviour, true), implode(', ', \Pixelboxx\EnumType\ScalingBehaviourType::getValidValues())), __LINE__);
        }
        $this->behaviour = $behaviour;
        return $this;
    }
}
