<?php

namespace Pixelboxx\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RenameFolderRequest StructType
 * Meta information extracted from the WSDL
 * - documentation: This functionality manages the multilanguage attributes of a folder. The valid attributes are: name and headline.
 * @subpackage Structs
 */
class RenameFolderRequest extends AbstractStructBase
{
    /**
     * The Attributes
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - ref: pb:Attributes
     * @var \Pixelboxx\StructType\AttributeListType
     */
    public $Attributes;
    /**
     * The FolderId
     * Meta information extracted from the WSDL
     * - documentation: Data Object Identification Value. See IDType for possible id types.
     * - base: xs:string
     * - pattern: \S+
     * @var string
     */
    public $FolderId;
    /**
     * The simulate
     * Meta information extracted from the WSDL
     * - default: false
     * - use: optional
     * @var bool
     */
    public $simulate;
    /**
     * Constructor method for RenameFolderRequest
     * @uses RenameFolderRequest::setAttributes()
     * @uses RenameFolderRequest::setFolderId()
     * @uses RenameFolderRequest::setSimulate()
     * @param \Pixelboxx\StructType\AttributeListType $attributes
     * @param string $folderId
     * @param bool $simulate
     */
    public function __construct(\Pixelboxx\StructType\AttributeListType $attributes = null, $folderId = null, $simulate = false)
    {
        $this
            ->setAttributes($attributes)
            ->setFolderId($folderId)
            ->setSimulate($simulate);
    }
    /**
     * Get Attributes value
     * @return \Pixelboxx\StructType\AttributeListType
     */
    public function getAttributes()
    {
        return $this->Attributes;
    }
    /**
     * Set Attributes value
     * @param \Pixelboxx\StructType\AttributeListType $attributes
     * @return \Pixelboxx\StructType\RenameFolderRequest
     */
    public function setAttributes(\Pixelboxx\StructType\AttributeListType $attributes = null)
    {
        $this->Attributes = $attributes;
        return $this;
    }
    /**
     * Get FolderId value
     * @return string|null
     */
    public function getFolderId()
    {
        return $this->FolderId;
    }
    /**
     * Set FolderId value
     * @param string $folderId
     * @return \Pixelboxx\StructType\RenameFolderRequest
     */
    public function setFolderId($folderId = null)
    {
        // validation for constraint: string
        if (!is_null($folderId) && !is_string($folderId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($folderId, true), gettype($folderId)), __LINE__);
        }
        // validation for constraint: pattern(\S+)
        if (!is_null($folderId) && !preg_match('/\\S+/', $folderId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression \S+', var_export($folderId, true)), __LINE__);
        }
        $this->FolderId = $folderId;
        return $this;
    }
    /**
     * Get simulate value
     * @return bool|null
     */
    public function getSimulate()
    {
        return $this->simulate;
    }
    /**
     * Set simulate value
     * @param bool $simulate
     * @return \Pixelboxx\StructType\RenameFolderRequest
     */
    public function setSimulate($simulate = false)
    {
        // validation for constraint: boolean
        if (!is_null($simulate) && !is_bool($simulate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($simulate, true), gettype($simulate)), __LINE__);
        }
        $this->simulate = $simulate;
        return $this;
    }
}
