<?php

namespace Pixelboxx\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RawDataType StructType
 * Meta information extracted from the WSDL
 * - documentation: Container für Rohdaten. Wird sowohl für Import wie auch für Abfrage der Daten verwendet. Beim Import ist nur "Location" Pflicht. Damit wird der Ort angegeben, an dem sich die Rohdaten befinden, davon wird mindestens "IncludedData"
 * in der ersten Version unterstützt. Bei der Abfrage hingegen wird in jedem Fall auch der ContentType der gelieferten Daten angegeben, soweit er ermittelbar ist, und bei nicht erkannten Formaten "application/ocetet-stream". Handelt es sich um
 * Bilddaten, werden noch ImageAttributes mitgeliefert, die mindestens die Angaben xsize und ysize enthalten.
 * @subpackage Structs
 */
class RawDataType extends AbstractStructBase
{
    /**
     * The ContentType
     * Meta information extracted from the WSDL
     * - base: xs:token
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ContentType;
    /**
     * The ImageAttributes
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Pixelboxx\StructType\ImageAttributesType
     */
    public $ImageAttributes;
    /**
     * The Location
     * @var \Pixelboxx\StructType\RawDataLocationType
     */
    public $Location;
    /**
     * The type
     * Meta information extracted from the WSDL
     * - default: custom
     * - use: optional
     * @var string
     */
    public $type;
    /**
     * Constructor method for RawDataType
     * @uses RawDataType::setContentType()
     * @uses RawDataType::setImageAttributes()
     * @uses RawDataType::setLocation()
     * @uses RawDataType::setType()
     * @param string $contentType
     * @param \Pixelboxx\StructType\ImageAttributesType $imageAttributes
     * @param \Pixelboxx\StructType\RawDataLocationType $location
     * @param string $type
     */
    public function __construct($contentType = null, \Pixelboxx\StructType\ImageAttributesType $imageAttributes = null, \Pixelboxx\StructType\RawDataLocationType $location = null, $type = 'custom')
    {
        $this
            ->setContentType($contentType)
            ->setImageAttributes($imageAttributes)
            ->setLocation($location)
            ->setType($type);
    }
    /**
     * Get ContentType value
     * @return string|null
     */
    public function getContentType()
    {
        return $this->ContentType;
    }
    /**
     * Set ContentType value
     * @param string $contentType
     * @return \Pixelboxx\StructType\RawDataType
     */
    public function setContentType($contentType = null)
    {
        // validation for constraint: string
        if (!is_null($contentType) && !is_string($contentType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($contentType, true), gettype($contentType)), __LINE__);
        }
        $this->ContentType = $contentType;
        return $this;
    }
    /**
     * Get ImageAttributes value
     * @return \Pixelboxx\StructType\ImageAttributesType|null
     */
    public function getImageAttributes()
    {
        return $this->ImageAttributes;
    }
    /**
     * Set ImageAttributes value
     * @param \Pixelboxx\StructType\ImageAttributesType $imageAttributes
     * @return \Pixelboxx\StructType\RawDataType
     */
    public function setImageAttributes(\Pixelboxx\StructType\ImageAttributesType $imageAttributes = null)
    {
        $this->ImageAttributes = $imageAttributes;
        return $this;
    }
    /**
     * Get Location value
     * @return \Pixelboxx\StructType\RawDataLocationType|null
     */
    public function getLocation()
    {
        return $this->Location;
    }
    /**
     * Set Location value
     * @param \Pixelboxx\StructType\RawDataLocationType $location
     * @return \Pixelboxx\StructType\RawDataType
     */
    public function setLocation(\Pixelboxx\StructType\RawDataLocationType $location = null)
    {
        $this->Location = $location;
        return $this;
    }
    /**
     * Get type value
     * @return string|null
     */
    public function getType()
    {
        return $this->type;
    }
    /**
     * Set type value
     * @uses \Pixelboxx\EnumType\RDType::valueIsValid()
     * @uses \Pixelboxx\EnumType\RDType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $type
     * @return \Pixelboxx\StructType\RawDataType
     */
    public function setType($type = 'custom')
    {
        // validation for constraint: enumeration
        if (!\Pixelboxx\EnumType\RDType::valueIsValid($type)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \Pixelboxx\EnumType\RDType', is_array($type) ? implode(', ', $type) : var_export($type, true), implode(', ', \Pixelboxx\EnumType\RDType::getValidValues())), __LINE__);
        }
        $this->type = $type;
        return $this;
    }
}
