<?php

namespace Pixelboxx\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RangeType StructType
 * Meta information extracted from the WSDL
 * - documentation: Ausschnitt, der von einem Folder geliefert wurde oder geliefert werden soll. Dabei ist "firstPos" die Nummer des ersten Elements, beginnend bei 0, und "size" die Anzahl der Elemente.
 * @subpackage Structs
 */
class RangeType extends AbstractStructBase
{
    /**
     * The size
     * Meta information extracted from the WSDL
     * - use: required
     * @var int
     */
    public $size;
    /**
     * The firstPos
     * Meta information extracted from the WSDL
     * - default: 0
     * - use: optional
     * @var int
     */
    public $firstPos;
    /**
     * Constructor method for RangeType
     * @uses RangeType::setSize()
     * @uses RangeType::setFirstPos()
     * @param int $size
     * @param int $firstPos
     */
    public function __construct($size = null, $firstPos = '0')
    {
        $this
            ->setSize($size)
            ->setFirstPos($firstPos);
    }
    /**
     * Get size value
     * @return int
     */
    public function getSize()
    {
        return $this->size;
    }
    /**
     * Set size value
     * @param int $size
     * @return \Pixelboxx\StructType\RangeType
     */
    public function setSize($size = null)
    {
        // validation for constraint: int
        if (!is_null($size) && !(is_int($size) || ctype_digit($size))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($size, true), gettype($size)), __LINE__);
        }
        $this->size = $size;
        return $this;
    }
    /**
     * Get firstPos value
     * @return int|null
     */
    public function getFirstPos()
    {
        return $this->firstPos;
    }
    /**
     * Set firstPos value
     * @param int $firstPos
     * @return \Pixelboxx\StructType\RangeType
     */
    public function setFirstPos($firstPos = '0')
    {
        // validation for constraint: int
        if (!is_null($firstPos) && !(is_int($firstPos) || ctype_digit($firstPos))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($firstPos, true), gettype($firstPos)), __LINE__);
        }
        $this->firstPos = $firstPos;
        return $this;
    }
}
