<?php

namespace Pixelboxx\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for MultiValueFacetSpecType StructType
 * Meta information extracted from the WSDL
 * - documentation: Multivalue-specification for a facet: Matches, if the object has at least one of these values for this facet. e.g. name pb1core__type and values image/jpeg, image/png means, the object is included in the search result, if it's type
 * is JPG or PNG and the result will contains a facet group with values image/jpeg and image/png and the number of objects for each type.
 * @subpackage Structs
 */
class MultiValueFacetSpecType extends AbstractStructBase
{
    /**
     * The Value
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 1
     * @var string[]
     */
    public $Value;
    /**
     * Constructor method for MultiValueFacetSpecType
     * @uses MultiValueFacetSpecType::setValue()
     * @param string[] $value
     */
    public function __construct(array $value = array())
    {
        $this
            ->setValue($value);
    }
    /**
     * Get Value value
     * @return string[]
     */
    public function getValue()
    {
        return $this->Value;
    }
    /**
     * This method is responsible for validating the values passed to the setValue method
     * This method is willingly generated in order to preserve the one-line inline validation within the setValue method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateValueForArrayConstraintsFromSetValue(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $multiValueFacetSpecTypeValueItem) {
            // validation for constraint: itemType
            if (!is_string($multiValueFacetSpecTypeValueItem)) {
                $invalidValues[] = is_object($multiValueFacetSpecTypeValueItem) ? get_class($multiValueFacetSpecTypeValueItem) : sprintf('%s(%s)', gettype($multiValueFacetSpecTypeValueItem), var_export($multiValueFacetSpecTypeValueItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Value property can only contain items of type string, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Value value
     * @throws \InvalidArgumentException
     * @param string[] $value
     * @return \Pixelboxx\StructType\MultiValueFacetSpecType
     */
    public function setValue(array $value = array())
    {
        // validation for constraint: array
        if ('' !== ($valueArrayErrorMessage = self::validateValueForArrayConstraintsFromSetValue($value))) {
            throw new \InvalidArgumentException($valueArrayErrorMessage, __LINE__);
        }
        $this->Value = $value;
        return $this;
    }
    /**
     * Add item to Value value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \Pixelboxx\StructType\MultiValueFacetSpecType
     */
    public function addToValue($item)
    {
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The Value property can only contain items of type string, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Value[] = $item;
        return $this;
    }
}
