<?php

namespace Pixelboxx\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for MLAttributeType StructType
 * Meta information extracted from the WSDL
 * - documentation: Multilanguage-Attribut mit Namen "n" (Attribut) und Liste von Werten "V" (Element) für jeweilige Sprache "lang" (Attribut von V).
 * @subpackage Structs
 */
class MLAttributeType extends AbstractStructBase
{
    /**
     * The n
     * Meta information extracted from the WSDL
     * - use: required
     * @var string
     */
    public $n;
    /**
     * The V
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \Pixelboxx\StructType\ValueType[]
     */
    public $V;
    /**
     * Constructor method for MLAttributeType
     * @uses MLAttributeType::setN()
     * @uses MLAttributeType::setV()
     * @param string $n
     * @param \Pixelboxx\StructType\ValueType[] $v
     */
    public function __construct($n = null, array $v = array())
    {
        $this
            ->setN($n)
            ->setV($v);
    }
    /**
     * Get n value
     * @return string
     */
    public function getN()
    {
        return $this->n;
    }
    /**
     * Set n value
     * @param string $n
     * @return \Pixelboxx\StructType\MLAttributeType
     */
    public function setN($n = null)
    {
        // validation for constraint: string
        if (!is_null($n) && !is_string($n)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($n, true), gettype($n)), __LINE__);
        }
        $this->n = $n;
        return $this;
    }
    /**
     * Get V value
     * @return \Pixelboxx\StructType\ValueType[]|null
     */
    public function getV()
    {
        return $this->V;
    }
    /**
     * This method is responsible for validating the values passed to the setV method
     * This method is willingly generated in order to preserve the one-line inline validation within the setV method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateVForArrayConstraintsFromSetV(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $mLAttributeTypeVItem) {
            // validation for constraint: itemType
            if (!$mLAttributeTypeVItem instanceof \Pixelboxx\StructType\ValueType) {
                $invalidValues[] = is_object($mLAttributeTypeVItem) ? get_class($mLAttributeTypeVItem) : sprintf('%s(%s)', gettype($mLAttributeTypeVItem), var_export($mLAttributeTypeVItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The V property can only contain items of type \Pixelboxx\StructType\ValueType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set V value
     * @throws \InvalidArgumentException
     * @param \Pixelboxx\StructType\ValueType[] $v
     * @return \Pixelboxx\StructType\MLAttributeType
     */
    public function setV(array $v = array())
    {
        // validation for constraint: array
        if ('' !== ($vArrayErrorMessage = self::validateVForArrayConstraintsFromSetV($v))) {
            throw new \InvalidArgumentException($vArrayErrorMessage, __LINE__);
        }
        $this->V = $v;
        return $this;
    }
    /**
     * Add item to V value
     * @throws \InvalidArgumentException
     * @param \Pixelboxx\StructType\ValueType $item
     * @return \Pixelboxx\StructType\MLAttributeType
     */
    public function addToV(\Pixelboxx\StructType\ValueType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \Pixelboxx\StructType\ValueType) {
            throw new \InvalidArgumentException(sprintf('The V property can only contain items of type \Pixelboxx\StructType\ValueType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->V[] = $item;
        return $this;
    }
}
