<?php

namespace Pixelboxx\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for LanguageRequestType StructType
 * Meta information extracted from the WSDL
 * - documentation: Liste der gewünschten bzw. akzeptierten Sprachen. Ist "multilang" auf "true" gesetzt, werden von mehrsprachigen Attributen alle gewünschten Sprachen als Multilanguage-Attribut ausgeliefert, ansonsten werden sie wie gewöhnliche
 * Attribute behandelt. In diesem Fall wird nur der Attributwert der ersten verfügbaren gewünschten Sprache als einfaches Attribut geliefert.
 * @subpackage Structs
 */
class LanguageRequestType extends AbstractStructBase
{
    /**
     * The Language
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 1
     * @var string[]
     */
    public $Language;
    /**
     * The multilang
     * Meta information extracted from the WSDL
     * - default: false
     * - use: optional
     * @var bool
     */
    public $multilang;
    /**
     * Constructor method for LanguageRequestType
     * @uses LanguageRequestType::setLanguage()
     * @uses LanguageRequestType::setMultilang()
     * @param string[] $language
     * @param bool $multilang
     */
    public function __construct(array $language = array(), $multilang = false)
    {
        $this
            ->setLanguage($language)
            ->setMultilang($multilang);
    }
    /**
     * Get Language value
     * @return string[]
     */
    public function getLanguage()
    {
        return $this->Language;
    }
    /**
     * This method is responsible for validating the values passed to the setLanguage method
     * This method is willingly generated in order to preserve the one-line inline validation within the setLanguage method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateLanguageForArrayConstraintsFromSetLanguage(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $languageRequestTypeLanguageItem) {
            // validation for constraint: itemType
            if (!is_string($languageRequestTypeLanguageItem)) {
                $invalidValues[] = is_object($languageRequestTypeLanguageItem) ? get_class($languageRequestTypeLanguageItem) : sprintf('%s(%s)', gettype($languageRequestTypeLanguageItem), var_export($languageRequestTypeLanguageItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Language property can only contain items of type language, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Language value
     * @throws \InvalidArgumentException
     * @param string[] $language
     * @return \Pixelboxx\StructType\LanguageRequestType
     */
    public function setLanguage(array $language = array())
    {
        // validation for constraint: array
        if ('' !== ($languageArrayErrorMessage = self::validateLanguageForArrayConstraintsFromSetLanguage($language))) {
            throw new \InvalidArgumentException($languageArrayErrorMessage, __LINE__);
        }
        $this->Language = $language;
        return $this;
    }
    /**
     * Add item to Language value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \Pixelboxx\StructType\LanguageRequestType
     */
    public function addToLanguage($item)
    {
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The Language property can only contain items of type language, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Language[] = $item;
        return $this;
    }
    /**
     * Get multilang value
     * @return bool|null
     */
    public function getMultilang()
    {
        return $this->multilang;
    }
    /**
     * Set multilang value
     * @param bool $multilang
     * @return \Pixelboxx\StructType\LanguageRequestType
     */
    public function setMultilang($multilang = false)
    {
        // validation for constraint: boolean
        if (!is_null($multilang) && !is_bool($multilang)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($multilang, true), gettype($multilang)), __LINE__);
        }
        $this->multilang = $multilang;
        return $this;
    }
}
