<?php

namespace Pixelboxx\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ItemType StructType
 * Meta information extracted from the WSDL
 * - documentation: Inhaltselement eines Folders, kann ein Objekt oder ein Folder sein.
 * @subpackage Structs
 */
class ItemType extends AbstractStructBase
{
    /**
     * The Object
     * Meta information extracted from the WSDL
     * - choice: Object | Folder
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - ref: pb:Object
     * @var \Pixelboxx\StructType\ObjectType
     */
    public $Object;
    /**
     * The Folder
     * Meta information extracted from the WSDL
     * - choice: Object | Folder
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - ref: pb:Folder
     * @var \Pixelboxx\StructType\FolderType
     */
    public $Folder;
    /**
     * Constructor method for ItemType
     * @uses ItemType::setObject()
     * @uses ItemType::setFolder()
     * @param \Pixelboxx\StructType\ObjectType $object
     * @param \Pixelboxx\StructType\FolderType $folder
     */
    public function __construct(\Pixelboxx\StructType\ObjectType $object = null, \Pixelboxx\StructType\FolderType $folder = null)
    {
        $this
            ->setObject($object)
            ->setFolder($folder);
    }
    /**
     * Get Object value
     * @return \Pixelboxx\StructType\ObjectType|null
     */
    public function getObject()
    {
        return isset($this->Object) ? $this->Object : null;
    }
    /**
     * This method is responsible for validating the value passed to the setObject method
     * This method is willingly generated in order to preserve the one-line inline validation within the setObject method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateObjectForChoiceConstraintsFromSetObject($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'Folder',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property Object can\'t be set as the property %s is already set. Only one property must be set among these properties: Object, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set Object value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param \Pixelboxx\StructType\ObjectType $object
     * @return \Pixelboxx\StructType\ItemType
     */
    public function setObject(\Pixelboxx\StructType\ObjectType $object = null)
    {
        // validation for constraint: choice(Object, Folder)
        if ('' !== ($objectChoiceErrorMessage = self::validateObjectForChoiceConstraintsFromSetObject($object))) {
            throw new \InvalidArgumentException($objectChoiceErrorMessage, __LINE__);
        }
        if (is_null($object) || (is_array($object) && empty($object))) {
            unset($this->Object);
        } else {
            $this->Object = $object;
        }
        return $this;
    }
    /**
     * Get Folder value
     * @return \Pixelboxx\StructType\FolderType|null
     */
    public function getFolder()
    {
        return isset($this->Folder) ? $this->Folder : null;
    }
    /**
     * This method is responsible for validating the value passed to the setFolder method
     * This method is willingly generated in order to preserve the one-line inline validation within the setFolder method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateFolderForChoiceConstraintsFromSetFolder($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'Object',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property Folder can\'t be set as the property %s is already set. Only one property must be set among these properties: Folder, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set Folder value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param \Pixelboxx\StructType\FolderType $folder
     * @return \Pixelboxx\StructType\ItemType
     */
    public function setFolder(\Pixelboxx\StructType\FolderType $folder = null)
    {
        // validation for constraint: choice(Object, Folder)
        if ('' !== ($folderChoiceErrorMessage = self::validateFolderForChoiceConstraintsFromSetFolder($folder))) {
            throw new \InvalidArgumentException($folderChoiceErrorMessage, __LINE__);
        }
        if (is_null($folder) || (is_array($folder) && empty($folder))) {
            unset($this->Folder);
        } else {
            $this->Folder = $folder;
        }
        return $this;
    }
}
