<?php

namespace Pixelboxx\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ImportFileRequest StructType
 * Meta information extracted from the WSDL
 * - documentation: Import einer Datei in die Mappe "TargetFolderId". Mittels "Data" werden die zu importierenden Daten angegeben, diese MÜSSEN vom Typ "fine" sein. z.Zt. ist es nur möglich, die Daten direkt mit zu übergeben (location "include"). In
 * zukünftigen Versionen können die Attribute und Zugriffsrechte/Access-Control-Attribute schon bei Erstellung festgelegt werden. Der Aufruf ist simulierbar,
 * @subpackage Structs
 */
class ImportFileRequest extends AbstractStructBase
{
    /**
     * The TargetFolderId
     * Meta information extracted from the WSDL
     * - documentation: Data Object Identification Value. See IDType for possible id types.
     * - base: xs:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: \S+
     * @var string
     */
    public $TargetFolderId;
    /**
     * The Data
     * @var \Pixelboxx\StructType\RawDataType
     */
    public $Data;
    /**
     * The AccessControl
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Pixelboxx\StructType\ACAttributeListType
     */
    public $AccessControl;
    /**
     * The Attributes
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: pb:Attributes
     * @var \Pixelboxx\StructType\AttributeListType
     */
    public $Attributes;
    /**
     * The DataSpec
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Pixelboxx\StructType\DataSpecificationType
     */
    public $DataSpec;
    /**
     * The WithMetadata
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Pixelboxx\StructType\MetadataRequestType
     */
    public $WithMetadata;
    /**
     * The simulate
     * Meta information extracted from the WSDL
     * - default: false
     * - use: optional
     * @var bool
     */
    public $simulate;
    /**
     * Constructor method for ImportFileRequest
     * @uses ImportFileRequest::setTargetFolderId()
     * @uses ImportFileRequest::setData()
     * @uses ImportFileRequest::setAccessControl()
     * @uses ImportFileRequest::setAttributes()
     * @uses ImportFileRequest::setDataSpec()
     * @uses ImportFileRequest::setWithMetadata()
     * @uses ImportFileRequest::setSimulate()
     * @param string $targetFolderId
     * @param \Pixelboxx\StructType\RawDataType $data
     * @param \Pixelboxx\StructType\ACAttributeListType $accessControl
     * @param \Pixelboxx\StructType\AttributeListType $attributes
     * @param \Pixelboxx\StructType\DataSpecificationType $dataSpec
     * @param \Pixelboxx\StructType\MetadataRequestType $withMetadata
     * @param bool $simulate
     */
    public function __construct($targetFolderId = null, \Pixelboxx\StructType\RawDataType $data = null, \Pixelboxx\StructType\ACAttributeListType $accessControl = null, \Pixelboxx\StructType\AttributeListType $attributes = null, \Pixelboxx\StructType\DataSpecificationType $dataSpec = null, \Pixelboxx\StructType\MetadataRequestType $withMetadata = null, $simulate = false)
    {
        $this
            ->setTargetFolderId($targetFolderId)
            ->setData($data)
            ->setAccessControl($accessControl)
            ->setAttributes($attributes)
            ->setDataSpec($dataSpec)
            ->setWithMetadata($withMetadata)
            ->setSimulate($simulate);
    }
    /**
     * Get TargetFolderId value
     * @return string|null
     */
    public function getTargetFolderId()
    {
        return $this->TargetFolderId;
    }
    /**
     * Set TargetFolderId value
     * @param string $targetFolderId
     * @return \Pixelboxx\StructType\ImportFileRequest
     */
    public function setTargetFolderId($targetFolderId = null)
    {
        // validation for constraint: string
        if (!is_null($targetFolderId) && !is_string($targetFolderId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($targetFolderId, true), gettype($targetFolderId)), __LINE__);
        }
        // validation for constraint: pattern(\S+)
        if (!is_null($targetFolderId) && !preg_match('/\\S+/', $targetFolderId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression \S+', var_export($targetFolderId, true)), __LINE__);
        }
        $this->TargetFolderId = $targetFolderId;
        return $this;
    }
    /**
     * Get Data value
     * @return \Pixelboxx\StructType\RawDataType|null
     */
    public function getData()
    {
        return $this->Data;
    }
    /**
     * Set Data value
     * @param \Pixelboxx\StructType\RawDataType $data
     * @return \Pixelboxx\StructType\ImportFileRequest
     */
    public function setData(\Pixelboxx\StructType\RawDataType $data = null)
    {
        $this->Data = $data;
        return $this;
    }
    /**
     * Get AccessControl value
     * @return \Pixelboxx\StructType\ACAttributeListType|null
     */
    public function getAccessControl()
    {
        return $this->AccessControl;
    }
    /**
     * Set AccessControl value
     * @param \Pixelboxx\StructType\ACAttributeListType $accessControl
     * @return \Pixelboxx\StructType\ImportFileRequest
     */
    public function setAccessControl(\Pixelboxx\StructType\ACAttributeListType $accessControl = null)
    {
        $this->AccessControl = $accessControl;
        return $this;
    }
    /**
     * Get Attributes value
     * @return \Pixelboxx\StructType\AttributeListType|null
     */
    public function getAttributes()
    {
        return $this->Attributes;
    }
    /**
     * Set Attributes value
     * @param \Pixelboxx\StructType\AttributeListType $attributes
     * @return \Pixelboxx\StructType\ImportFileRequest
     */
    public function setAttributes(\Pixelboxx\StructType\AttributeListType $attributes = null)
    {
        $this->Attributes = $attributes;
        return $this;
    }
    /**
     * Get DataSpec value
     * @return \Pixelboxx\StructType\DataSpecificationType|null
     */
    public function getDataSpec()
    {
        return $this->DataSpec;
    }
    /**
     * Set DataSpec value
     * @param \Pixelboxx\StructType\DataSpecificationType $dataSpec
     * @return \Pixelboxx\StructType\ImportFileRequest
     */
    public function setDataSpec(\Pixelboxx\StructType\DataSpecificationType $dataSpec = null)
    {
        $this->DataSpec = $dataSpec;
        return $this;
    }
    /**
     * Get WithMetadata value
     * @return \Pixelboxx\StructType\MetadataRequestType|null
     */
    public function getWithMetadata()
    {
        return $this->WithMetadata;
    }
    /**
     * Set WithMetadata value
     * @param \Pixelboxx\StructType\MetadataRequestType $withMetadata
     * @return \Pixelboxx\StructType\ImportFileRequest
     */
    public function setWithMetadata(\Pixelboxx\StructType\MetadataRequestType $withMetadata = null)
    {
        $this->WithMetadata = $withMetadata;
        return $this;
    }
    /**
     * Get simulate value
     * @return bool|null
     */
    public function getSimulate()
    {
        return $this->simulate;
    }
    /**
     * Set simulate value
     * @param bool $simulate
     * @return \Pixelboxx\StructType\ImportFileRequest
     */
    public function setSimulate($simulate = false)
    {
        // validation for constraint: boolean
        if (!is_null($simulate) && !is_bool($simulate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($simulate, true), gettype($simulate)), __LINE__);
        }
        $this->simulate = $simulate;
        return $this;
    }
}
