<?php

namespace Pixelboxx\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ImportFileNewVersionRequest StructType
 * Meta information extracted from the WSDL
 * - documentation: Erstellt eine neue Version von dem Objekt "ObjectId" mit den neuen Daten "Data". Restliche Parameter: Siehe Dateiimport. Der Aufruf ist simulierbar.
 * @subpackage Structs
 */
class ImportFileNewVersionRequest extends AbstractStructBase
{
    /**
     * The ObjectId
     * Meta information extracted from the WSDL
     * - documentation: Data Object Identification Value. See IDType for possible id types.
     * - base: xs:string
     * - pattern: \S+
     * @var string
     */
    public $ObjectId;
    /**
     * The Data
     * @var \Pixelboxx\StructType\RawDataType
     */
    public $Data;
    /**
     * The Attributes
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: pb:Attributes
     * @var \Pixelboxx\StructType\AttributeListType
     */
    public $Attributes;
    /**
     * The simulate
     * Meta information extracted from the WSDL
     * - default: false
     * - use: optional
     * @var bool
     */
    public $simulate;
    /**
     * Constructor method for ImportFileNewVersionRequest
     * @uses ImportFileNewVersionRequest::setObjectId()
     * @uses ImportFileNewVersionRequest::setData()
     * @uses ImportFileNewVersionRequest::setAttributes()
     * @uses ImportFileNewVersionRequest::setSimulate()
     * @param string $objectId
     * @param \Pixelboxx\StructType\RawDataType $data
     * @param \Pixelboxx\StructType\AttributeListType $attributes
     * @param bool $simulate
     */
    public function __construct($objectId = null, \Pixelboxx\StructType\RawDataType $data = null, \Pixelboxx\StructType\AttributeListType $attributes = null, $simulate = false)
    {
        $this
            ->setObjectId($objectId)
            ->setData($data)
            ->setAttributes($attributes)
            ->setSimulate($simulate);
    }
    /**
     * Get ObjectId value
     * @return string|null
     */
    public function getObjectId()
    {
        return $this->ObjectId;
    }
    /**
     * Set ObjectId value
     * @param string $objectId
     * @return \Pixelboxx\StructType\ImportFileNewVersionRequest
     */
    public function setObjectId($objectId = null)
    {
        // validation for constraint: string
        if (!is_null($objectId) && !is_string($objectId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($objectId, true), gettype($objectId)), __LINE__);
        }
        // validation for constraint: pattern(\S+)
        if (!is_null($objectId) && !preg_match('/\\S+/', $objectId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression \S+', var_export($objectId, true)), __LINE__);
        }
        $this->ObjectId = $objectId;
        return $this;
    }
    /**
     * Get Data value
     * @return \Pixelboxx\StructType\RawDataType|null
     */
    public function getData()
    {
        return $this->Data;
    }
    /**
     * Set Data value
     * @param \Pixelboxx\StructType\RawDataType $data
     * @return \Pixelboxx\StructType\ImportFileNewVersionRequest
     */
    public function setData(\Pixelboxx\StructType\RawDataType $data = null)
    {
        $this->Data = $data;
        return $this;
    }
    /**
     * Get Attributes value
     * @return \Pixelboxx\StructType\AttributeListType|null
     */
    public function getAttributes()
    {
        return $this->Attributes;
    }
    /**
     * Set Attributes value
     * @param \Pixelboxx\StructType\AttributeListType $attributes
     * @return \Pixelboxx\StructType\ImportFileNewVersionRequest
     */
    public function setAttributes(\Pixelboxx\StructType\AttributeListType $attributes = null)
    {
        $this->Attributes = $attributes;
        return $this;
    }
    /**
     * Get simulate value
     * @return bool|null
     */
    public function getSimulate()
    {
        return $this->simulate;
    }
    /**
     * Set simulate value
     * @param bool $simulate
     * @return \Pixelboxx\StructType\ImportFileNewVersionRequest
     */
    public function setSimulate($simulate = false)
    {
        // validation for constraint: boolean
        if (!is_null($simulate) && !is_bool($simulate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($simulate, true), gettype($simulate)), __LINE__);
        }
        $this->simulate = $simulate;
        return $this;
    }
}
