<?php

namespace Pixelboxx\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ImageOpType StructType
 * Meta information extracted from the WSDL
 * - documentation: Image Processor Operation. See ImageProcessParamsType for details.
 * @subpackage Structs
 */
class ImageOpType extends AbstractStructBase
{
    /**
     * The name
     * Meta information extracted from the WSDL
     * - use: required
     * @var string
     */
    public $name;
    /**
     * The ImageOpParam
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \Pixelboxx\StructType\ImageOpParamType[]
     */
    public $ImageOpParam;
    /**
     * Constructor method for ImageOpType
     * @uses ImageOpType::setName()
     * @uses ImageOpType::setImageOpParam()
     * @param string $name
     * @param \Pixelboxx\StructType\ImageOpParamType[] $imageOpParam
     */
    public function __construct($name = null, array $imageOpParam = array())
    {
        $this
            ->setName($name)
            ->setImageOpParam($imageOpParam);
    }
    /**
     * Get name value
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }
    /**
     * Set name value
     * @param string $name
     * @return \Pixelboxx\StructType\ImageOpType
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($name, true), gettype($name)), __LINE__);
        }
        $this->name = $name;
        return $this;
    }
    /**
     * Get ImageOpParam value
     * @return \Pixelboxx\StructType\ImageOpParamType[]|null
     */
    public function getImageOpParam()
    {
        return $this->ImageOpParam;
    }
    /**
     * This method is responsible for validating the values passed to the setImageOpParam method
     * This method is willingly generated in order to preserve the one-line inline validation within the setImageOpParam method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateImageOpParamForArrayConstraintsFromSetImageOpParam(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $imageOpTypeImageOpParamItem) {
            // validation for constraint: itemType
            if (!$imageOpTypeImageOpParamItem instanceof \Pixelboxx\StructType\ImageOpParamType) {
                $invalidValues[] = is_object($imageOpTypeImageOpParamItem) ? get_class($imageOpTypeImageOpParamItem) : sprintf('%s(%s)', gettype($imageOpTypeImageOpParamItem), var_export($imageOpTypeImageOpParamItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The ImageOpParam property can only contain items of type \Pixelboxx\StructType\ImageOpParamType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set ImageOpParam value
     * @throws \InvalidArgumentException
     * @param \Pixelboxx\StructType\ImageOpParamType[] $imageOpParam
     * @return \Pixelboxx\StructType\ImageOpType
     */
    public function setImageOpParam(array $imageOpParam = array())
    {
        // validation for constraint: array
        if ('' !== ($imageOpParamArrayErrorMessage = self::validateImageOpParamForArrayConstraintsFromSetImageOpParam($imageOpParam))) {
            throw new \InvalidArgumentException($imageOpParamArrayErrorMessage, __LINE__);
        }
        $this->ImageOpParam = $imageOpParam;
        return $this;
    }
    /**
     * Add item to ImageOpParam value
     * @throws \InvalidArgumentException
     * @param \Pixelboxx\StructType\ImageOpParamType $item
     * @return \Pixelboxx\StructType\ImageOpType
     */
    public function addToImageOpParam(\Pixelboxx\StructType\ImageOpParamType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \Pixelboxx\StructType\ImageOpParamType) {
            throw new \InvalidArgumentException(sprintf('The ImageOpParam property can only contain items of type \Pixelboxx\StructType\ImageOpParamType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->ImageOpParam[] = $item;
        return $this;
    }
}
