<?php

namespace Pixelboxx\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetUsageListResponse StructType
 * Meta information extracted from the WSDL
 * - documentation: Response of the "getUsageList" request. Remarks: The attribute "Size" contains the number of total entries of the request (allowing for the requests "includeArchived"), while the response may only contain a limited sublist with
 * "Range".
 * @subpackage Structs
 */
class GetUsageListResponse extends AbstractStructBase
{
    /**
     * The Range
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \Pixelboxx\StructType\RangeType
     */
    public $Range;
    /**
     * The UsageListResultType
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - ref: pb:UsageListResultType
     * @var \Pixelboxx\StructType\UsageListResultType[]
     */
    public $UsageListResultType;
    /**
     * The size
     * Meta information extracted from the WSDL
     * - default: 0
     * - use: optional
     * @var int
     */
    public $size;
    /**
     * Constructor method for GetUsageListResponse
     * @uses GetUsageListResponse::setRange()
     * @uses GetUsageListResponse::setUsageListResultType()
     * @uses GetUsageListResponse::setSize()
     * @param \Pixelboxx\StructType\RangeType $range
     * @param \Pixelboxx\StructType\UsageListResultType[] $usageListResultType
     * @param int $size
     */
    public function __construct(\Pixelboxx\StructType\RangeType $range = null, array $usageListResultType = array(), $size = '0')
    {
        $this
            ->setRange($range)
            ->setUsageListResultType($usageListResultType)
            ->setSize($size);
    }
    /**
     * Get Range value
     * @return \Pixelboxx\StructType\RangeType
     */
    public function getRange()
    {
        return $this->Range;
    }
    /**
     * Set Range value
     * @param \Pixelboxx\StructType\RangeType $range
     * @return \Pixelboxx\StructType\GetUsageListResponse
     */
    public function setRange(\Pixelboxx\StructType\RangeType $range = null)
    {
        $this->Range = $range;
        return $this;
    }
    /**
     * Get UsageListResultType value
     * @return \Pixelboxx\StructType\UsageListResultType[]|null
     */
    public function getUsageListResultType()
    {
        return $this->UsageListResultType;
    }
    /**
     * This method is responsible for validating the values passed to the setUsageListResultType method
     * This method is willingly generated in order to preserve the one-line inline validation within the setUsageListResultType method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateUsageListResultTypeForArrayConstraintsFromSetUsageListResultType(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $getUsageListResponseUsageListResultTypeItem) {
            // validation for constraint: itemType
            if (!$getUsageListResponseUsageListResultTypeItem instanceof \Pixelboxx\StructType\UsageListResultType) {
                $invalidValues[] = is_object($getUsageListResponseUsageListResultTypeItem) ? get_class($getUsageListResponseUsageListResultTypeItem) : sprintf('%s(%s)', gettype($getUsageListResponseUsageListResultTypeItem), var_export($getUsageListResponseUsageListResultTypeItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The UsageListResultType property can only contain items of type \Pixelboxx\StructType\UsageListResultType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set UsageListResultType value
     * @throws \InvalidArgumentException
     * @param \Pixelboxx\StructType\UsageListResultType[] $usageListResultType
     * @return \Pixelboxx\StructType\GetUsageListResponse
     */
    public function setUsageListResultType(array $usageListResultType = array())
    {
        // validation for constraint: array
        if ('' !== ($usageListResultTypeArrayErrorMessage = self::validateUsageListResultTypeForArrayConstraintsFromSetUsageListResultType($usageListResultType))) {
            throw new \InvalidArgumentException($usageListResultTypeArrayErrorMessage, __LINE__);
        }
        $this->UsageListResultType = $usageListResultType;
        return $this;
    }
    /**
     * Add item to UsageListResultType value
     * @throws \InvalidArgumentException
     * @param \Pixelboxx\StructType\UsageListResultType $item
     * @return \Pixelboxx\StructType\GetUsageListResponse
     */
    public function addToUsageListResultType(\Pixelboxx\StructType\UsageListResultType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \Pixelboxx\StructType\UsageListResultType) {
            throw new \InvalidArgumentException(sprintf('The UsageListResultType property can only contain items of type \Pixelboxx\StructType\UsageListResultType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->UsageListResultType[] = $item;
        return $this;
    }
    /**
     * Get size value
     * @return int|null
     */
    public function getSize()
    {
        return $this->size;
    }
    /**
     * Set size value
     * @param int $size
     * @return \Pixelboxx\StructType\GetUsageListResponse
     */
    public function setSize($size = '0')
    {
        // validation for constraint: int
        if (!is_null($size) && !(is_int($size) || ctype_digit($size))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($size, true), gettype($size)), __LINE__);
        }
        $this->size = $size;
        return $this;
    }
}
