<?php

namespace Pixelboxx\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetUsageListRequest StructType
 * Meta information extracted from the WSDL
 * - documentation: Request of the usage list for object "ObjectID", paged by "Range", which optionally return "includeArchived" entries. Remarks: Even if no "Range" was requested, the service may only return a smaller sublist with a pre-configured
 * size.
 * @subpackage Structs
 */
class GetUsageListRequest extends AbstractStructBase
{
    /**
     * The ObjectId
     * Meta information extracted from the WSDL
     * - documentation: Data Object Identification Value. See IDType for possible id types.
     * - base: xs:string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: \S+
     * @var string
     */
    public $ObjectId;
    /**
     * The Range
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Pixelboxx\StructType\RangeType
     */
    public $Range;
    /**
     * The includeArchived
     * Meta information extracted from the WSDL
     * - default: false
     * - use: optional
     * @var bool
     */
    public $includeArchived;
    /**
     * Constructor method for GetUsageListRequest
     * @uses GetUsageListRequest::setObjectId()
     * @uses GetUsageListRequest::setRange()
     * @uses GetUsageListRequest::setIncludeArchived()
     * @param string $objectId
     * @param \Pixelboxx\StructType\RangeType $range
     * @param bool $includeArchived
     */
    public function __construct($objectId = null, \Pixelboxx\StructType\RangeType $range = null, $includeArchived = false)
    {
        $this
            ->setObjectId($objectId)
            ->setRange($range)
            ->setIncludeArchived($includeArchived);
    }
    /**
     * Get ObjectId value
     * @return string
     */
    public function getObjectId()
    {
        return $this->ObjectId;
    }
    /**
     * Set ObjectId value
     * @param string $objectId
     * @return \Pixelboxx\StructType\GetUsageListRequest
     */
    public function setObjectId($objectId = null)
    {
        // validation for constraint: string
        if (!is_null($objectId) && !is_string($objectId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($objectId, true), gettype($objectId)), __LINE__);
        }
        // validation for constraint: pattern(\S+)
        if (!is_null($objectId) && !preg_match('/\\S+/', $objectId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression \S+', var_export($objectId, true)), __LINE__);
        }
        $this->ObjectId = $objectId;
        return $this;
    }
    /**
     * Get Range value
     * @return \Pixelboxx\StructType\RangeType|null
     */
    public function getRange()
    {
        return $this->Range;
    }
    /**
     * Set Range value
     * @param \Pixelboxx\StructType\RangeType $range
     * @return \Pixelboxx\StructType\GetUsageListRequest
     */
    public function setRange(\Pixelboxx\StructType\RangeType $range = null)
    {
        $this->Range = $range;
        return $this;
    }
    /**
     * Get includeArchived value
     * @return bool|null
     */
    public function getIncludeArchived()
    {
        return $this->includeArchived;
    }
    /**
     * Set includeArchived value
     * @param bool $includeArchived
     * @return \Pixelboxx\StructType\GetUsageListRequest
     */
    public function setIncludeArchived($includeArchived = false)
    {
        // validation for constraint: boolean
        if (!is_null($includeArchived) && !is_bool($includeArchived)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($includeArchived, true), gettype($includeArchived)), __LINE__);
        }
        $this->includeArchived = $includeArchived;
        return $this;
    }
}
