<?php

namespace Pixelboxx\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetObjectRequest StructType
 * Meta information extracted from the WSDL
 * - documentation: Holt das Objekt (oder die Mappe bei VC) mit der angegebenen ObjectId. Dabei können sowohl Metadaten (Attribute, Zugriffsrechte..) wie auch Rohdaten angefordert werden. Keins von beidem anzufordern ist nicht sehr sinnvoll, wenn auch
 * zulässig.
 * @subpackage Structs
 */
class GetObjectRequest extends AbstractStructBase
{
    /**
     * The ObjectId
     * Meta information extracted from the WSDL
     * - documentation: Data Object Identification Value. See IDType for possible id types.
     * - base: xs:string
     * - pattern: \S+
     * @var string
     */
    public $ObjectId;
    /**
     * The DataSpec
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Pixelboxx\StructType\DataSpecificationType
     */
    public $DataSpec;
    /**
     * The WithMetadata
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Pixelboxx\StructType\MetadataRequestType
     */
    public $WithMetadata;
    /**
     * The WithRawData
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Pixelboxx\StructType\RawDataListRequestType
     */
    public $WithRawData;
    /**
     * The WithXLinks
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Pixelboxx\StructType\XLinkListObjectsRequestType
     */
    public $WithXLinks;
    /**
     * Constructor method for GetObjectRequest
     * @uses GetObjectRequest::setObjectId()
     * @uses GetObjectRequest::setDataSpec()
     * @uses GetObjectRequest::setWithMetadata()
     * @uses GetObjectRequest::setWithRawData()
     * @uses GetObjectRequest::setWithXLinks()
     * @param string $objectId
     * @param \Pixelboxx\StructType\DataSpecificationType $dataSpec
     * @param \Pixelboxx\StructType\MetadataRequestType $withMetadata
     * @param \Pixelboxx\StructType\RawDataListRequestType $withRawData
     * @param \Pixelboxx\StructType\XLinkListObjectsRequestType $withXLinks
     */
    public function __construct($objectId = null, \Pixelboxx\StructType\DataSpecificationType $dataSpec = null, \Pixelboxx\StructType\MetadataRequestType $withMetadata = null, \Pixelboxx\StructType\RawDataListRequestType $withRawData = null, \Pixelboxx\StructType\XLinkListObjectsRequestType $withXLinks = null)
    {
        $this
            ->setObjectId($objectId)
            ->setDataSpec($dataSpec)
            ->setWithMetadata($withMetadata)
            ->setWithRawData($withRawData)
            ->setWithXLinks($withXLinks);
    }
    /**
     * Get ObjectId value
     * @return string|null
     */
    public function getObjectId()
    {
        return $this->ObjectId;
    }
    /**
     * Set ObjectId value
     * @param string $objectId
     * @return \Pixelboxx\StructType\GetObjectRequest
     */
    public function setObjectId($objectId = null)
    {
        // validation for constraint: string
        if (!is_null($objectId) && !is_string($objectId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($objectId, true), gettype($objectId)), __LINE__);
        }
        // validation for constraint: pattern(\S+)
        if (!is_null($objectId) && !preg_match('/\\S+/', $objectId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression \S+', var_export($objectId, true)), __LINE__);
        }
        $this->ObjectId = $objectId;
        return $this;
    }
    /**
     * Get DataSpec value
     * @return \Pixelboxx\StructType\DataSpecificationType|null
     */
    public function getDataSpec()
    {
        return $this->DataSpec;
    }
    /**
     * Set DataSpec value
     * @param \Pixelboxx\StructType\DataSpecificationType $dataSpec
     * @return \Pixelboxx\StructType\GetObjectRequest
     */
    public function setDataSpec(\Pixelboxx\StructType\DataSpecificationType $dataSpec = null)
    {
        $this->DataSpec = $dataSpec;
        return $this;
    }
    /**
     * Get WithMetadata value
     * @return \Pixelboxx\StructType\MetadataRequestType|null
     */
    public function getWithMetadata()
    {
        return $this->WithMetadata;
    }
    /**
     * Set WithMetadata value
     * @param \Pixelboxx\StructType\MetadataRequestType $withMetadata
     * @return \Pixelboxx\StructType\GetObjectRequest
     */
    public function setWithMetadata(\Pixelboxx\StructType\MetadataRequestType $withMetadata = null)
    {
        $this->WithMetadata = $withMetadata;
        return $this;
    }
    /**
     * Get WithRawData value
     * @return \Pixelboxx\StructType\RawDataListRequestType|null
     */
    public function getWithRawData()
    {
        return $this->WithRawData;
    }
    /**
     * Set WithRawData value
     * @param \Pixelboxx\StructType\RawDataListRequestType $withRawData
     * @return \Pixelboxx\StructType\GetObjectRequest
     */
    public function setWithRawData(\Pixelboxx\StructType\RawDataListRequestType $withRawData = null)
    {
        $this->WithRawData = $withRawData;
        return $this;
    }
    /**
     * Get WithXLinks value
     * @return \Pixelboxx\StructType\XLinkListObjectsRequestType|null
     */
    public function getWithXLinks()
    {
        return $this->WithXLinks;
    }
    /**
     * Set WithXLinks value
     * @param \Pixelboxx\StructType\XLinkListObjectsRequestType $withXLinks
     * @return \Pixelboxx\StructType\GetObjectRequest
     */
    public function setWithXLinks(\Pixelboxx\StructType\XLinkListObjectsRequestType $withXLinks = null)
    {
        $this->WithXLinks = $withXLinks;
        return $this;
    }
}
