<?php

namespace Pixelboxx\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetFolderStructureRequest StructType
 * Meta information extracted from the WSDL
 * - documentation: Abfrage der Mappenstruktur. Ist eine TopFolderId angegeben, so wird der Untermappenbaum dieser Mappe geliefert, ansonsten der vollständige Mappenbaum beginnend mit der Rootmappe. WithMetadata ist zur Zeit nur zur Spezifizierung der
 * gewünschten Sprachen gültig (wirkt sich also nur auf das Attribut "name" aus, weitere Attribute können damit zur Zeit nicht abgefragt werden).
 * @subpackage Structs
 */
class GetFolderStructureRequest extends AbstractStructBase
{
    /**
     * The TopFolderId
     * Meta information extracted from the WSDL
     * - documentation: Data Object Identification Value. See IDType for possible id types.
     * - base: xs:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: \S+
     * @var string
     */
    public $TopFolderId;
    /**
     * The WithMetadata
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Pixelboxx\StructType\MetadataRequestType
     */
    public $WithMetadata;
    /**
     * Constructor method for GetFolderStructureRequest
     * @uses GetFolderStructureRequest::setTopFolderId()
     * @uses GetFolderStructureRequest::setWithMetadata()
     * @param string $topFolderId
     * @param \Pixelboxx\StructType\MetadataRequestType $withMetadata
     */
    public function __construct($topFolderId = null, \Pixelboxx\StructType\MetadataRequestType $withMetadata = null)
    {
        $this
            ->setTopFolderId($topFolderId)
            ->setWithMetadata($withMetadata);
    }
    /**
     * Get TopFolderId value
     * @return string|null
     */
    public function getTopFolderId()
    {
        return $this->TopFolderId;
    }
    /**
     * Set TopFolderId value
     * @param string $topFolderId
     * @return \Pixelboxx\StructType\GetFolderStructureRequest
     */
    public function setTopFolderId($topFolderId = null)
    {
        // validation for constraint: string
        if (!is_null($topFolderId) && !is_string($topFolderId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($topFolderId, true), gettype($topFolderId)), __LINE__);
        }
        // validation for constraint: pattern(\S+)
        if (!is_null($topFolderId) && !preg_match('/\\S+/', $topFolderId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression \S+', var_export($topFolderId, true)), __LINE__);
        }
        $this->TopFolderId = $topFolderId;
        return $this;
    }
    /**
     * Get WithMetadata value
     * @return \Pixelboxx\StructType\MetadataRequestType|null
     */
    public function getWithMetadata()
    {
        return $this->WithMetadata;
    }
    /**
     * Set WithMetadata value
     * @param \Pixelboxx\StructType\MetadataRequestType $withMetadata
     * @return \Pixelboxx\StructType\GetFolderStructureRequest
     */
    public function setWithMetadata(\Pixelboxx\StructType\MetadataRequestType $withMetadata = null)
    {
        $this->WithMetadata = $withMetadata;
        return $this;
    }
}
