<?php

namespace Pixelboxx\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for FolderStructureType StructType
 * Meta information extracted from the WSDL
 * - documentation: Mappenstruktur der Mappe mit DOI "doi" und Namen "name". Gibt alle Untermappen "F" rekursiv an. Attribute und Access-Controll-Attribute können ebenfalls auf Anfrage angegeben sein.
 * @subpackage Structs
 */
class FolderStructureType extends AbstractStructBase
{
    /**
     * The doi
     * Meta information extracted from the WSDL
     * - documentation: Data Object Identification Value. See IDType for possible id types.
     * - base: xs:string
     * - pattern: \S+
     * - use: required
     * @var string
     */
    public $doi;
    /**
     * The AccessControl
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Pixelboxx\StructType\ACAttributeListType
     */
    public $AccessControl;
    /**
     * The Attributes
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: pb:Attributes
     * @var \Pixelboxx\StructType\AttributeListType
     */
    public $Attributes;
    /**
     * The F
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \Pixelboxx\StructType\FolderStructureType[]
     */
    public $F;
    /**
     * The name
     * Meta information extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $name;
    /**
     * Constructor method for FolderStructureType
     * @uses FolderStructureType::setDoi()
     * @uses FolderStructureType::setAccessControl()
     * @uses FolderStructureType::setAttributes()
     * @uses FolderStructureType::setF()
     * @uses FolderStructureType::setName()
     * @param string $doi
     * @param \Pixelboxx\StructType\ACAttributeListType $accessControl
     * @param \Pixelboxx\StructType\AttributeListType $attributes
     * @param \Pixelboxx\StructType\FolderStructureType[] $f
     * @param string $name
     */
    public function __construct($doi = null, \Pixelboxx\StructType\ACAttributeListType $accessControl = null, \Pixelboxx\StructType\AttributeListType $attributes = null, array $f = array(), $name = null)
    {
        $this
            ->setDoi($doi)
            ->setAccessControl($accessControl)
            ->setAttributes($attributes)
            ->setF($f)
            ->setName($name);
    }
    /**
     * Get doi value
     * @return string
     */
    public function getDoi()
    {
        return $this->doi;
    }
    /**
     * Set doi value
     * @param string $doi
     * @return \Pixelboxx\StructType\FolderStructureType
     */
    public function setDoi($doi = null)
    {
        // validation for constraint: string
        if (!is_null($doi) && !is_string($doi)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($doi, true), gettype($doi)), __LINE__);
        }
        // validation for constraint: pattern(\S+)
        if (!is_null($doi) && !preg_match('/\\S+/', $doi)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression \S+', var_export($doi, true)), __LINE__);
        }
        $this->doi = $doi;
        return $this;
    }
    /**
     * Get AccessControl value
     * @return \Pixelboxx\StructType\ACAttributeListType|null
     */
    public function getAccessControl()
    {
        return $this->AccessControl;
    }
    /**
     * Set AccessControl value
     * @param \Pixelboxx\StructType\ACAttributeListType $accessControl
     * @return \Pixelboxx\StructType\FolderStructureType
     */
    public function setAccessControl(\Pixelboxx\StructType\ACAttributeListType $accessControl = null)
    {
        $this->AccessControl = $accessControl;
        return $this;
    }
    /**
     * Get Attributes value
     * @return \Pixelboxx\StructType\AttributeListType|null
     */
    public function getAttributes()
    {
        return $this->Attributes;
    }
    /**
     * Set Attributes value
     * @param \Pixelboxx\StructType\AttributeListType $attributes
     * @return \Pixelboxx\StructType\FolderStructureType
     */
    public function setAttributes(\Pixelboxx\StructType\AttributeListType $attributes = null)
    {
        $this->Attributes = $attributes;
        return $this;
    }
    /**
     * Get F value
     * @return \Pixelboxx\StructType\FolderStructureType[]|null
     */
    public function getF()
    {
        return $this->F;
    }
    /**
     * This method is responsible for validating the values passed to the setF method
     * This method is willingly generated in order to preserve the one-line inline validation within the setF method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateFForArrayConstraintsFromSetF(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $folderStructureTypeFItem) {
            // validation for constraint: itemType
            if (!$folderStructureTypeFItem instanceof \Pixelboxx\StructType\FolderStructureType) {
                $invalidValues[] = is_object($folderStructureTypeFItem) ? get_class($folderStructureTypeFItem) : sprintf('%s(%s)', gettype($folderStructureTypeFItem), var_export($folderStructureTypeFItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The F property can only contain items of type \Pixelboxx\StructType\FolderStructureType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set F value
     * @throws \InvalidArgumentException
     * @param \Pixelboxx\StructType\FolderStructureType[] $f
     * @return \Pixelboxx\StructType\FolderStructureType
     */
    public function setF(array $f = array())
    {
        // validation for constraint: array
        if ('' !== ($fArrayErrorMessage = self::validateFForArrayConstraintsFromSetF($f))) {
            throw new \InvalidArgumentException($fArrayErrorMessage, __LINE__);
        }
        $this->F = $f;
        return $this;
    }
    /**
     * Add item to F value
     * @throws \InvalidArgumentException
     * @param \Pixelboxx\StructType\FolderStructureType $item
     * @return \Pixelboxx\StructType\FolderStructureType
     */
    public function addToF(\Pixelboxx\StructType\FolderStructureType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \Pixelboxx\StructType\FolderStructureType) {
            throw new \InvalidArgumentException(sprintf('The F property can only contain items of type \Pixelboxx\StructType\FolderStructureType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->F[] = $item;
        return $this;
    }
    /**
     * Get name value
     * @return string|null
     */
    public function getName()
    {
        return $this->name;
    }
    /**
     * Set name value
     * @param string $name
     * @return \Pixelboxx\StructType\FolderStructureType
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($name, true), gettype($name)), __LINE__);
        }
        $this->name = $name;
        return $this;
    }
}
