<?php

namespace Pixelboxx\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DeleteFolderRequest StructType
 * Meta information extracted from the WSDL
 * - documentation: Löscht die Mappe mit der angegebenen Id. Rekursive Löschaufrufe sind möglich ab V581.
 * @subpackage Structs
 */
class DeleteFolderRequest extends AbstractStructBase
{
    /**
     * The FolderId
     * Meta information extracted from the WSDL
     * - documentation: Data Object Identification Value. See IDType for possible id types.
     * - base: xs:string
     * - pattern: \S+
     * @var string
     */
    public $FolderId;
    /**
     * The recursive
     * Meta information extracted from the WSDL
     * - default: false
     * @var bool
     */
    public $recursive;
    /**
     * The simulate
     * Meta information extracted from the WSDL
     * - default: false
     * - use: optional
     * @var bool
     */
    public $simulate;
    /**
     * Constructor method for DeleteFolderRequest
     * @uses DeleteFolderRequest::setFolderId()
     * @uses DeleteFolderRequest::setRecursive()
     * @uses DeleteFolderRequest::setSimulate()
     * @param string $folderId
     * @param bool $recursive
     * @param bool $simulate
     */
    public function __construct($folderId = null, $recursive = false, $simulate = false)
    {
        $this
            ->setFolderId($folderId)
            ->setRecursive($recursive)
            ->setSimulate($simulate);
    }
    /**
     * Get FolderId value
     * @return string|null
     */
    public function getFolderId()
    {
        return $this->FolderId;
    }
    /**
     * Set FolderId value
     * @param string $folderId
     * @return \Pixelboxx\StructType\DeleteFolderRequest
     */
    public function setFolderId($folderId = null)
    {
        // validation for constraint: string
        if (!is_null($folderId) && !is_string($folderId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($folderId, true), gettype($folderId)), __LINE__);
        }
        // validation for constraint: pattern(\S+)
        if (!is_null($folderId) && !preg_match('/\\S+/', $folderId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression \S+', var_export($folderId, true)), __LINE__);
        }
        $this->FolderId = $folderId;
        return $this;
    }
    /**
     * Get recursive value
     * @return bool|null
     */
    public function getRecursive()
    {
        return $this->recursive;
    }
    /**
     * Set recursive value
     * @param bool $recursive
     * @return \Pixelboxx\StructType\DeleteFolderRequest
     */
    public function setRecursive($recursive = false)
    {
        // validation for constraint: boolean
        if (!is_null($recursive) && !is_bool($recursive)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($recursive, true), gettype($recursive)), __LINE__);
        }
        $this->recursive = $recursive;
        return $this;
    }
    /**
     * Get simulate value
     * @return bool|null
     */
    public function getSimulate()
    {
        return $this->simulate;
    }
    /**
     * Set simulate value
     * @param bool $simulate
     * @return \Pixelboxx\StructType\DeleteFolderRequest
     */
    public function setSimulate($simulate = false)
    {
        // validation for constraint: boolean
        if (!is_null($simulate) && !is_bool($simulate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($simulate, true), gettype($simulate)), __LINE__);
        }
        $this->simulate = $simulate;
        return $this;
    }
}
