<?php

namespace Pixelboxx\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CreateObjectRequest StructType
 * Meta information extracted from the WSDL
 * - documentation: Erzeugt ein neues Pixelobjekt mit dem angegebenen Mimetype und Attributen
 * @subpackage Structs
 */
class CreateObjectRequest extends AbstractStructBase
{
    /**
     * The ContentType
     * Meta information extracted from the WSDL
     * - base: xs:token
     * @var string
     */
    public $ContentType;
    /**
     * The ParentFolders
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Pixelboxx\StructType\IDListType
     */
    public $ParentFolders;
    /**
     * The Attributes
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: pb:Attributes
     * @var \Pixelboxx\StructType\AttributeListType
     */
    public $Attributes;
    /**
     * The XLinks
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Pixelboxx\StructType\XLinkListRefsType
     */
    public $XLinks;
    /**
     * The simulate
     * Meta information extracted from the WSDL
     * - default: false
     * - use: optional
     * @var bool
     */
    public $simulate;
    /**
     * Constructor method for CreateObjectRequest
     * @uses CreateObjectRequest::setContentType()
     * @uses CreateObjectRequest::setParentFolders()
     * @uses CreateObjectRequest::setAttributes()
     * @uses CreateObjectRequest::setXLinks()
     * @uses CreateObjectRequest::setSimulate()
     * @param string $contentType
     * @param \Pixelboxx\StructType\IDListType $parentFolders
     * @param \Pixelboxx\StructType\AttributeListType $attributes
     * @param \Pixelboxx\StructType\XLinkListRefsType $xLinks
     * @param bool $simulate
     */
    public function __construct($contentType = null, \Pixelboxx\StructType\IDListType $parentFolders = null, \Pixelboxx\StructType\AttributeListType $attributes = null, \Pixelboxx\StructType\XLinkListRefsType $xLinks = null, $simulate = false)
    {
        $this
            ->setContentType($contentType)
            ->setParentFolders($parentFolders)
            ->setAttributes($attributes)
            ->setXLinks($xLinks)
            ->setSimulate($simulate);
    }
    /**
     * Get ContentType value
     * @return string|null
     */
    public function getContentType()
    {
        return $this->ContentType;
    }
    /**
     * Set ContentType value
     * @param string $contentType
     * @return \Pixelboxx\StructType\CreateObjectRequest
     */
    public function setContentType($contentType = null)
    {
        // validation for constraint: string
        if (!is_null($contentType) && !is_string($contentType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($contentType, true), gettype($contentType)), __LINE__);
        }
        $this->ContentType = $contentType;
        return $this;
    }
    /**
     * Get ParentFolders value
     * @return \Pixelboxx\StructType\IDListType|null
     */
    public function getParentFolders()
    {
        return $this->ParentFolders;
    }
    /**
     * Set ParentFolders value
     * @param \Pixelboxx\StructType\IDListType $parentFolders
     * @return \Pixelboxx\StructType\CreateObjectRequest
     */
    public function setParentFolders(\Pixelboxx\StructType\IDListType $parentFolders = null)
    {
        $this->ParentFolders = $parentFolders;
        return $this;
    }
    /**
     * Get Attributes value
     * @return \Pixelboxx\StructType\AttributeListType|null
     */
    public function getAttributes()
    {
        return $this->Attributes;
    }
    /**
     * Set Attributes value
     * @param \Pixelboxx\StructType\AttributeListType $attributes
     * @return \Pixelboxx\StructType\CreateObjectRequest
     */
    public function setAttributes(\Pixelboxx\StructType\AttributeListType $attributes = null)
    {
        $this->Attributes = $attributes;
        return $this;
    }
    /**
     * Get XLinks value
     * @return \Pixelboxx\StructType\XLinkListRefsType|null
     */
    public function getXLinks()
    {
        return $this->XLinks;
    }
    /**
     * Set XLinks value
     * @param \Pixelboxx\StructType\XLinkListRefsType $xLinks
     * @return \Pixelboxx\StructType\CreateObjectRequest
     */
    public function setXLinks(\Pixelboxx\StructType\XLinkListRefsType $xLinks = null)
    {
        $this->XLinks = $xLinks;
        return $this;
    }
    /**
     * Get simulate value
     * @return bool|null
     */
    public function getSimulate()
    {
        return $this->simulate;
    }
    /**
     * Set simulate value
     * @param bool $simulate
     * @return \Pixelboxx\StructType\CreateObjectRequest
     */
    public function setSimulate($simulate = false)
    {
        // validation for constraint: boolean
        if (!is_null($simulate) && !is_bool($simulate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($simulate, true), gettype($simulate)), __LINE__);
        }
        $this->simulate = $simulate;
        return $this;
    }
}
