<?php

namespace Pixelboxx\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CreateFolderRequest StructType
 * Meta information extracted from the WSDL
 * - documentation: Erzeugt eine Untermappe in der Mappe "ParentFolderId". Von der Mappe ist zumindest der Name anzugeben. (Ist von der zu erzeugenden Mappe eine DOI angegeben, so wird sie ignoriert). Es ist möglich, Attribute und
 * Access-Control-Attribute bei dem Aufruf in der Mappe mit zu übergeben. In zukünftigen Versionen wird es möglich sein, auf diese Art schon bei der Erstellung Attribute und Zugriffsrechte festzulegen. inheritACAttributes - die Rechte der Obermappe
 * werden vererbt auf die Untermappe (Ab V615)
 * @subpackage Structs
 */
class CreateFolderRequest extends AbstractStructBase
{
    /**
     * The ParentFolderId
     * Meta information extracted from the WSDL
     * - documentation: Data Object Identification Value. See IDType for possible id types.
     * - base: xs:string
     * - pattern: \S+
     * @var string
     */
    public $ParentFolderId;
    /**
     * The Folder
     * Meta information extracted from the WSDL
     * - ref: pb:Folder
     * @var \Pixelboxx\StructType\FolderType
     */
    public $Folder;
    /**
     * The simulate
     * Meta information extracted from the WSDL
     * - default: false
     * - use: optional
     * @var bool
     */
    public $simulate;
    /**
     * The inheritACAttributes
     * Meta information extracted from the WSDL
     * - default: false
     * - use: optional
     * @var bool
     */
    public $inheritACAttributes;
    /**
     * Constructor method for CreateFolderRequest
     * @uses CreateFolderRequest::setParentFolderId()
     * @uses CreateFolderRequest::setFolder()
     * @uses CreateFolderRequest::setSimulate()
     * @uses CreateFolderRequest::setInheritACAttributes()
     * @param string $parentFolderId
     * @param \Pixelboxx\StructType\FolderType $folder
     * @param bool $simulate
     * @param bool $inheritACAttributes
     */
    public function __construct($parentFolderId = null, \Pixelboxx\StructType\FolderType $folder = null, $simulate = false, $inheritACAttributes = false)
    {
        $this
            ->setParentFolderId($parentFolderId)
            ->setFolder($folder)
            ->setSimulate($simulate)
            ->setInheritACAttributes($inheritACAttributes);
    }
    /**
     * Get ParentFolderId value
     * @return string|null
     */
    public function getParentFolderId()
    {
        return $this->ParentFolderId;
    }
    /**
     * Set ParentFolderId value
     * @param string $parentFolderId
     * @return \Pixelboxx\StructType\CreateFolderRequest
     */
    public function setParentFolderId($parentFolderId = null)
    {
        // validation for constraint: string
        if (!is_null($parentFolderId) && !is_string($parentFolderId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($parentFolderId, true), gettype($parentFolderId)), __LINE__);
        }
        // validation for constraint: pattern(\S+)
        if (!is_null($parentFolderId) && !preg_match('/\\S+/', $parentFolderId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression \S+', var_export($parentFolderId, true)), __LINE__);
        }
        $this->ParentFolderId = $parentFolderId;
        return $this;
    }
    /**
     * Get Folder value
     * @return \Pixelboxx\StructType\FolderType|null
     */
    public function getFolder()
    {
        return $this->Folder;
    }
    /**
     * Set Folder value
     * @param \Pixelboxx\StructType\FolderType $folder
     * @return \Pixelboxx\StructType\CreateFolderRequest
     */
    public function setFolder(\Pixelboxx\StructType\FolderType $folder = null)
    {
        $this->Folder = $folder;
        return $this;
    }
    /**
     * Get simulate value
     * @return bool|null
     */
    public function getSimulate()
    {
        return $this->simulate;
    }
    /**
     * Set simulate value
     * @param bool $simulate
     * @return \Pixelboxx\StructType\CreateFolderRequest
     */
    public function setSimulate($simulate = false)
    {
        // validation for constraint: boolean
        if (!is_null($simulate) && !is_bool($simulate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($simulate, true), gettype($simulate)), __LINE__);
        }
        $this->simulate = $simulate;
        return $this;
    }
    /**
     * Get inheritACAttributes value
     * @return bool|null
     */
    public function getInheritACAttributes()
    {
        return $this->inheritACAttributes;
    }
    /**
     * Set inheritACAttributes value
     * @param bool $inheritACAttributes
     * @return \Pixelboxx\StructType\CreateFolderRequest
     */
    public function setInheritACAttributes($inheritACAttributes = false)
    {
        // validation for constraint: boolean
        if (!is_null($inheritACAttributes) && !is_bool($inheritACAttributes)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($inheritACAttributes, true), gettype($inheritACAttributes)), __LINE__);
        }
        $this->inheritACAttributes = $inheritACAttributes;
        return $this;
    }
}
