<?php

namespace Pixelboxx\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CommonRequestParamType StructType
 * @subpackage Structs
 */
class CommonRequestParamType extends AbstractStructBase
{
    /**
     * The ActionId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ActionId;
    /**
     * The User
     * @var string
     */
    public $User;
    /**
     * The AccessRole
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var string[]
     */
    public $AccessRole;
    /**
     * The Language
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Language;
    /**
     * Constructor method for CommonRequestParamType
     * @uses CommonRequestParamType::setActionId()
     * @uses CommonRequestParamType::setUser()
     * @uses CommonRequestParamType::setAccessRole()
     * @uses CommonRequestParamType::setLanguage()
     * @param string $actionId
     * @param string $user
     * @param string[] $accessRole
     * @param string $language
     */
    public function __construct($actionId = null, $user = null, array $accessRole = array(), $language = null)
    {
        $this
            ->setActionId($actionId)
            ->setUser($user)
            ->setAccessRole($accessRole)
            ->setLanguage($language);
    }
    /**
     * Get ActionId value
     * @return string|null
     */
    public function getActionId()
    {
        return $this->ActionId;
    }
    /**
     * Set ActionId value
     * @param string $actionId
     * @return \Pixelboxx\StructType\CommonRequestParamType
     */
    public function setActionId($actionId = null)
    {
        // validation for constraint: string
        if (!is_null($actionId) && !is_string($actionId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($actionId, true), gettype($actionId)), __LINE__);
        }
        $this->ActionId = $actionId;
        return $this;
    }
    /**
     * Get User value
     * @return string|null
     */
    public function getUser()
    {
        return $this->User;
    }
    /**
     * Set User value
     * @param string $user
     * @return \Pixelboxx\StructType\CommonRequestParamType
     */
    public function setUser($user = null)
    {
        // validation for constraint: string
        if (!is_null($user) && !is_string($user)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($user, true), gettype($user)), __LINE__);
        }
        $this->User = $user;
        return $this;
    }
    /**
     * Get AccessRole value
     * @return string[]|null
     */
    public function getAccessRole()
    {
        return $this->AccessRole;
    }
    /**
     * This method is responsible for validating the values passed to the setAccessRole method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAccessRole method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateAccessRoleForArrayConstraintsFromSetAccessRole(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $commonRequestParamTypeAccessRoleItem) {
            // validation for constraint: itemType
            if (!is_string($commonRequestParamTypeAccessRoleItem)) {
                $invalidValues[] = is_object($commonRequestParamTypeAccessRoleItem) ? get_class($commonRequestParamTypeAccessRoleItem) : sprintf('%s(%s)', gettype($commonRequestParamTypeAccessRoleItem), var_export($commonRequestParamTypeAccessRoleItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The AccessRole property can only contain items of type string, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set AccessRole value
     * @throws \InvalidArgumentException
     * @param string[] $accessRole
     * @return \Pixelboxx\StructType\CommonRequestParamType
     */
    public function setAccessRole(array $accessRole = array())
    {
        // validation for constraint: array
        if ('' !== ($accessRoleArrayErrorMessage = self::validateAccessRoleForArrayConstraintsFromSetAccessRole($accessRole))) {
            throw new \InvalidArgumentException($accessRoleArrayErrorMessage, __LINE__);
        }
        $this->AccessRole = $accessRole;
        return $this;
    }
    /**
     * Add item to AccessRole value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \Pixelboxx\StructType\CommonRequestParamType
     */
    public function addToAccessRole($item)
    {
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The AccessRole property can only contain items of type string, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->AccessRole[] = $item;
        return $this;
    }
    /**
     * Get Language value
     * @return string|null
     */
    public function getLanguage()
    {
        return $this->Language;
    }
    /**
     * Set Language value
     * @param string $language
     * @return \Pixelboxx\StructType\CommonRequestParamType
     */
    public function setLanguage($language = null)
    {
        // validation for constraint: string
        if (!is_null($language) && !is_string($language)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($language, true), gettype($language)), __LINE__);
        }
        $this->Language = $language;
        return $this;
    }
}
