<?php

namespace Pixelboxx\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AttributeType StructType
 * Meta information extracted from the WSDL
 * - documentation: Attribut mit Namen "n" und dem Attributwert als Inhalt. Dabei kann "lang" die Sprache angeben, in der der Attributwert tatsächlich zurückgegeben wurde. Diese Angabe kann nur entfallen, wenn der Wert in der einzigen gewünschten
 * Sprache ausgeliefert werden konnte oder sprachunabhängig ist oder keine Anforderung an die Sprache gestellt wurde. Wenn "ml" den Wert "true" hat, könnte dieses Attribut für andere Sprachen andere Werte haben (Multilanguage).
 * @subpackage Structs
 */
class AttributeType extends AbstractStructBase
{
    /**
     * The n
     * Meta information extracted from the WSDL
     * - use: required
     * @var string
     */
    public $n;
    /**
     * The _
     * @var string
     */
    public $_;
    /**
     * The lang
     * Meta information extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $lang;
    /**
     * The ml
     * Meta information extracted from the WSDL
     * - default: false
     * - use: optional
     * @var bool
     */
    public $ml;
    /**
     * Constructor method for AttributeType
     * @uses AttributeType::setN()
     * @uses AttributeType::set_()
     * @uses AttributeType::setLang()
     * @uses AttributeType::setMl()
     * @param string $n
     * @param string $_
     * @param string $lang
     * @param bool $ml
     */
    public function __construct($n = null, $_ = null, $lang = null, $ml = false)
    {
        $this
            ->setN($n)
            ->set_($_)
            ->setLang($lang)
            ->setMl($ml);
    }
    /**
     * Get n value
     * @return string
     */
    public function getN()
    {
        return $this->n;
    }
    /**
     * Set n value
     * @param string $n
     * @return \Pixelboxx\StructType\AttributeType
     */
    public function setN($n = null)
    {
        // validation for constraint: string
        if (!is_null($n) && !is_string($n)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($n, true), gettype($n)), __LINE__);
        }
        $this->n = $n;
        return $this;
    }
    /**
     * Get _ value
     * @return string|null
     */
    public function get_()
    {
        return $this->_;
    }
    /**
     * Set _ value
     * @param string $_
     * @return \Pixelboxx\StructType\AttributeType
     */
    public function set_($_ = null)
    {
        // validation for constraint: string
        if (!is_null($_) && !is_string($_)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($_, true), gettype($_)), __LINE__);
        }
        $this->_ = $_;
        return $this;
    }
    /**
     * Get lang value
     * @return string|null
     */
    public function getLang()
    {
        return $this->lang;
    }
    /**
     * Set lang value
     * @param string $lang
     * @return \Pixelboxx\StructType\AttributeType
     */
    public function setLang($lang = null)
    {
        // validation for constraint: string
        if (!is_null($lang) && !is_string($lang)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lang, true), gettype($lang)), __LINE__);
        }
        $this->lang = $lang;
        return $this;
    }
    /**
     * Get ml value
     * @return bool|null
     */
    public function getMl()
    {
        return $this->ml;
    }
    /**
     * Set ml value
     * @param bool $ml
     * @return \Pixelboxx\StructType\AttributeType
     */
    public function setMl($ml = false)
    {
        // validation for constraint: boolean
        if (!is_null($ml) && !is_bool($ml)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($ml, true), gettype($ml)), __LINE__);
        }
        $this->ml = $ml;
        return $this;
    }
}
