<?php

namespace Pixelboxx\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AttributeListType StructType
 * Meta information extracted from the WSDL
 * - documentation: Liste von Attributen, bestehend aus einfachen Attributen "A" und Multilanguage-Attributen "MLA".
 * @subpackage Structs
 */
class AttributeListType extends AbstractStructBase
{
    /**
     * The A
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \Pixelboxx\StructType\AttributeType[]
     */
    public $A;
    /**
     * The MLA
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \Pixelboxx\StructType\MLAttributeType[]
     */
    public $MLA;
    /**
     * The DA
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \Pixelboxx\StructType\DisplayableAttributeType[]
     */
    public $DA;
    /**
     * Constructor method for AttributeListType
     * @uses AttributeListType::setA()
     * @uses AttributeListType::setMLA()
     * @uses AttributeListType::setDA()
     * @param \Pixelboxx\StructType\AttributeType[] $a
     * @param \Pixelboxx\StructType\MLAttributeType[] $mLA
     * @param \Pixelboxx\StructType\DisplayableAttributeType[] $dA
     */
    public function __construct(array $a = array(), array $mLA = array(), array $dA = array())
    {
        $this
            ->setA($a)
            ->setMLA($mLA)
            ->setDA($dA);
    }
    /**
     * Get A value
     * @return \Pixelboxx\StructType\AttributeType[]|null
     */
    public function getA()
    {
        return $this->A;
    }
    /**
     * This method is responsible for validating the values passed to the setA method
     * This method is willingly generated in order to preserve the one-line inline validation within the setA method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateAForArrayConstraintsFromSetA(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $attributeListTypeAItem) {
            // validation for constraint: itemType
            if (!$attributeListTypeAItem instanceof \Pixelboxx\StructType\AttributeType) {
                $invalidValues[] = is_object($attributeListTypeAItem) ? get_class($attributeListTypeAItem) : sprintf('%s(%s)', gettype($attributeListTypeAItem), var_export($attributeListTypeAItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The A property can only contain items of type \Pixelboxx\StructType\AttributeType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set A value
     * @throws \InvalidArgumentException
     * @param \Pixelboxx\StructType\AttributeType[] $a
     * @return \Pixelboxx\StructType\AttributeListType
     */
    public function setA(array $a = array())
    {
        // validation for constraint: array
        if ('' !== ($aArrayErrorMessage = self::validateAForArrayConstraintsFromSetA($a))) {
            throw new \InvalidArgumentException($aArrayErrorMessage, __LINE__);
        }
        $this->A = $a;
        return $this;
    }
    /**
     * Add item to A value
     * @throws \InvalidArgumentException
     * @param \Pixelboxx\StructType\AttributeType $item
     * @return \Pixelboxx\StructType\AttributeListType
     */
    public function addToA(\Pixelboxx\StructType\AttributeType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \Pixelboxx\StructType\AttributeType) {
            throw new \InvalidArgumentException(sprintf('The A property can only contain items of type \Pixelboxx\StructType\AttributeType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->A[] = $item;
        return $this;
    }
    /**
     * Get MLA value
     * @return \Pixelboxx\StructType\MLAttributeType[]|null
     */
    public function getMLA()
    {
        return $this->MLA;
    }
    /**
     * This method is responsible for validating the values passed to the setMLA method
     * This method is willingly generated in order to preserve the one-line inline validation within the setMLA method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateMLAForArrayConstraintsFromSetMLA(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $attributeListTypeMLAItem) {
            // validation for constraint: itemType
            if (!$attributeListTypeMLAItem instanceof \Pixelboxx\StructType\MLAttributeType) {
                $invalidValues[] = is_object($attributeListTypeMLAItem) ? get_class($attributeListTypeMLAItem) : sprintf('%s(%s)', gettype($attributeListTypeMLAItem), var_export($attributeListTypeMLAItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The MLA property can only contain items of type \Pixelboxx\StructType\MLAttributeType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set MLA value
     * @throws \InvalidArgumentException
     * @param \Pixelboxx\StructType\MLAttributeType[] $mLA
     * @return \Pixelboxx\StructType\AttributeListType
     */
    public function setMLA(array $mLA = array())
    {
        // validation for constraint: array
        if ('' !== ($mLAArrayErrorMessage = self::validateMLAForArrayConstraintsFromSetMLA($mLA))) {
            throw new \InvalidArgumentException($mLAArrayErrorMessage, __LINE__);
        }
        $this->MLA = $mLA;
        return $this;
    }
    /**
     * Add item to MLA value
     * @throws \InvalidArgumentException
     * @param \Pixelboxx\StructType\MLAttributeType $item
     * @return \Pixelboxx\StructType\AttributeListType
     */
    public function addToMLA(\Pixelboxx\StructType\MLAttributeType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \Pixelboxx\StructType\MLAttributeType) {
            throw new \InvalidArgumentException(sprintf('The MLA property can only contain items of type \Pixelboxx\StructType\MLAttributeType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->MLA[] = $item;
        return $this;
    }
    /**
     * Get DA value
     * @return \Pixelboxx\StructType\DisplayableAttributeType[]|null
     */
    public function getDA()
    {
        return $this->DA;
    }
    /**
     * This method is responsible for validating the values passed to the setDA method
     * This method is willingly generated in order to preserve the one-line inline validation within the setDA method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateDAForArrayConstraintsFromSetDA(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $attributeListTypeDAItem) {
            // validation for constraint: itemType
            if (!$attributeListTypeDAItem instanceof \Pixelboxx\StructType\DisplayableAttributeType) {
                $invalidValues[] = is_object($attributeListTypeDAItem) ? get_class($attributeListTypeDAItem) : sprintf('%s(%s)', gettype($attributeListTypeDAItem), var_export($attributeListTypeDAItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The DA property can only contain items of type \Pixelboxx\StructType\DisplayableAttributeType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set DA value
     * @throws \InvalidArgumentException
     * @param \Pixelboxx\StructType\DisplayableAttributeType[] $dA
     * @return \Pixelboxx\StructType\AttributeListType
     */
    public function setDA(array $dA = array())
    {
        // validation for constraint: array
        if ('' !== ($dAArrayErrorMessage = self::validateDAForArrayConstraintsFromSetDA($dA))) {
            throw new \InvalidArgumentException($dAArrayErrorMessage, __LINE__);
        }
        $this->DA = $dA;
        return $this;
    }
    /**
     * Add item to DA value
     * @throws \InvalidArgumentException
     * @param \Pixelboxx\StructType\DisplayableAttributeType $item
     * @return \Pixelboxx\StructType\AttributeListType
     */
    public function addToDA(\Pixelboxx\StructType\DisplayableAttributeType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \Pixelboxx\StructType\DisplayableAttributeType) {
            throw new \InvalidArgumentException(sprintf('The DA property can only contain items of type \Pixelboxx\StructType\DisplayableAttributeType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->DA[] = $item;
        return $this;
    }
}
