<?php

namespace Pixelboxx\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AbstractObjectType StructType
 * Meta information extracted from the WSDL
 * - documentation: Common definitions of objects and folders. Both have ID(s), attributes, access control attributes and a name. oid - will only be set if id type oid is requested customid - will only be set if id type custom id is requested
 * @subpackage Structs
 */
abstract class AbstractObjectType extends AbstractStructBase
{
    /**
     * The doi
     * Meta information extracted from the WSDL
     * - documentation: Data Object Identification Value. See IDType for possible id types.
     * - base: xs:string
     * - pattern: \S+
     * - use: required
     * @var string
     */
    public $doi;
    /**
     * The name
     * Meta information extracted from the WSDL
     * - use: required
     * @var string
     */
    public $name;
    /**
     * The AccessControl
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Pixelboxx\StructType\ACAttributeListType
     */
    public $AccessControl;
    /**
     * The Attributes
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: pb:Attributes
     * @var \Pixelboxx\StructType\AttributeListType
     */
    public $Attributes;
    /**
     * The ParentFolders
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Pixelboxx\StructType\IDListType
     */
    public $ParentFolders;
    /**
     * The oid
     * Meta information extracted from the WSDL
     * - documentation: Data Object Identification Value. See IDType for possible id types.
     * - base: xs:string
     * - pattern: \S+
     * - use: optional
     * @var string
     */
    public $oid;
    /**
     * The customid
     * Meta information extracted from the WSDL
     * - documentation: Data Object Identification Value. See IDType for possible id types.
     * - base: xs:string
     * - pattern: \S+
     * - use: optional
     * @var string
     */
    public $customid;
    /**
     * Constructor method for AbstractObjectType
     * @uses AbstractObjectType::setDoi()
     * @uses AbstractObjectType::setName()
     * @uses AbstractObjectType::setAccessControl()
     * @uses AbstractObjectType::setAttributes()
     * @uses AbstractObjectType::setParentFolders()
     * @uses AbstractObjectType::setOid()
     * @uses AbstractObjectType::setCustomid()
     * @param string $doi
     * @param string $name
     * @param \Pixelboxx\StructType\ACAttributeListType $accessControl
     * @param \Pixelboxx\StructType\AttributeListType $attributes
     * @param \Pixelboxx\StructType\IDListType $parentFolders
     * @param string $oid
     * @param string $customid
     */
    public function __construct($doi = null, $name = null, \Pixelboxx\StructType\ACAttributeListType $accessControl = null, \Pixelboxx\StructType\AttributeListType $attributes = null, \Pixelboxx\StructType\IDListType $parentFolders = null, $oid = null, $customid = null)
    {
        $this
            ->setDoi($doi)
            ->setName($name)
            ->setAccessControl($accessControl)
            ->setAttributes($attributes)
            ->setParentFolders($parentFolders)
            ->setOid($oid)
            ->setCustomid($customid);
    }
    /**
     * Get doi value
     * @return string
     */
    public function getDoi()
    {
        return $this->doi;
    }
    /**
     * Set doi value
     * @param string $doi
     * @return \Pixelboxx\StructType\AbstractObjectType
     */
    public function setDoi($doi = null)
    {
        // validation for constraint: string
        if (!is_null($doi) && !is_string($doi)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($doi, true), gettype($doi)), __LINE__);
        }
        // validation for constraint: pattern(\S+)
        if (!is_null($doi) && !preg_match('/\\S+/', $doi)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression \S+', var_export($doi, true)), __LINE__);
        }
        $this->doi = $doi;
        return $this;
    }
    /**
     * Get name value
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }
    /**
     * Set name value
     * @param string $name
     * @return \Pixelboxx\StructType\AbstractObjectType
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($name, true), gettype($name)), __LINE__);
        }
        $this->name = $name;
        return $this;
    }
    /**
     * Get AccessControl value
     * @return \Pixelboxx\StructType\ACAttributeListType|null
     */
    public function getAccessControl()
    {
        return $this->AccessControl;
    }
    /**
     * Set AccessControl value
     * @param \Pixelboxx\StructType\ACAttributeListType $accessControl
     * @return \Pixelboxx\StructType\AbstractObjectType
     */
    public function setAccessControl(\Pixelboxx\StructType\ACAttributeListType $accessControl = null)
    {
        $this->AccessControl = $accessControl;
        return $this;
    }
    /**
     * Get Attributes value
     * @return \Pixelboxx\StructType\AttributeListType|null
     */
    public function getAttributes()
    {
        return $this->Attributes;
    }
    /**
     * Set Attributes value
     * @param \Pixelboxx\StructType\AttributeListType $attributes
     * @return \Pixelboxx\StructType\AbstractObjectType
     */
    public function setAttributes(\Pixelboxx\StructType\AttributeListType $attributes = null)
    {
        $this->Attributes = $attributes;
        return $this;
    }
    /**
     * Get ParentFolders value
     * @return \Pixelboxx\StructType\IDListType|null
     */
    public function getParentFolders()
    {
        return $this->ParentFolders;
    }
    /**
     * Set ParentFolders value
     * @param \Pixelboxx\StructType\IDListType $parentFolders
     * @return \Pixelboxx\StructType\AbstractObjectType
     */
    public function setParentFolders(\Pixelboxx\StructType\IDListType $parentFolders = null)
    {
        $this->ParentFolders = $parentFolders;
        return $this;
    }
    /**
     * Get oid value
     * @return string|null
     */
    public function getOid()
    {
        return $this->oid;
    }
    /**
     * Set oid value
     * @param string $oid
     * @return \Pixelboxx\StructType\AbstractObjectType
     */
    public function setOid($oid = null)
    {
        // validation for constraint: string
        if (!is_null($oid) && !is_string($oid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($oid, true), gettype($oid)), __LINE__);
        }
        // validation for constraint: pattern(\S+)
        if (!is_null($oid) && !preg_match('/\\S+/', $oid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression \S+', var_export($oid, true)), __LINE__);
        }
        $this->oid = $oid;
        return $this;
    }
    /**
     * Get customid value
     * @return string|null
     */
    public function getCustomid()
    {
        return $this->customid;
    }
    /**
     * Set customid value
     * @param string $customid
     * @return \Pixelboxx\StructType\AbstractObjectType
     */
    public function setCustomid($customid = null)
    {
        // validation for constraint: string
        if (!is_null($customid) && !is_string($customid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($customid, true), gettype($customid)), __LINE__);
        }
        // validation for constraint: pattern(\S+)
        if (!is_null($customid) && !preg_match('/\\S+/', $customid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression \S+', var_export($customid, true)), __LINE__);
        }
        $this->customid = $customid;
        return $this;
    }
}
