<?php

namespace Pixelboxx\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AbstractFacetType StructType
 * Meta information extracted from the WSDL
 * - documentation: Common attributes of all facets. "count" is the number of occurences in the total search result ("how many objects have this facet?"). This is the number of objects the search would return, if this facet was the only further
 * restriction to the otherwise same search. "active" is true, if this facet was specified in the search request. Some facets may contain Label for different languages (if LabelLanguages were requested), this is the label of the property value. This is
 * typical for the property types Topic and TopicList.
 * @subpackage Structs
 */
abstract class AbstractFacetType extends AbstractStructBase
{
    /**
     * The count
     * Meta information extracted from the WSDL
     * - use: required
     * @var int
     */
    public $count;
    /**
     * The Label
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \Pixelboxx\StructType\DisplayNameType[]
     */
    public $Label;
    /**
     * The active
     * Meta information extracted from the WSDL
     * - default: false
     * - use: optional
     * @var bool
     */
    public $active;
    /**
     * Constructor method for AbstractFacetType
     * @uses AbstractFacetType::setCount()
     * @uses AbstractFacetType::setLabel()
     * @uses AbstractFacetType::setActive()
     * @param int $count
     * @param \Pixelboxx\StructType\DisplayNameType[] $label
     * @param bool $active
     */
    public function __construct($count = null, array $label = array(), $active = false)
    {
        $this
            ->setCount($count)
            ->setLabel($label)
            ->setActive($active);
    }
    /**
     * Get count value
     * @return int
     */
    public function getCount()
    {
        return $this->count;
    }
    /**
     * Set count value
     * @param int $count
     * @return \Pixelboxx\StructType\AbstractFacetType
     */
    public function setCount($count = null)
    {
        // validation for constraint: int
        if (!is_null($count) && !(is_int($count) || ctype_digit($count))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($count, true), gettype($count)), __LINE__);
        }
        $this->count = $count;
        return $this;
    }
    /**
     * Get Label value
     * @return \Pixelboxx\StructType\DisplayNameType[]|null
     */
    public function getLabel()
    {
        return $this->Label;
    }
    /**
     * This method is responsible for validating the values passed to the setLabel method
     * This method is willingly generated in order to preserve the one-line inline validation within the setLabel method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateLabelForArrayConstraintsFromSetLabel(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $abstractFacetTypeLabelItem) {
            // validation for constraint: itemType
            if (!$abstractFacetTypeLabelItem instanceof \Pixelboxx\StructType\DisplayNameType) {
                $invalidValues[] = is_object($abstractFacetTypeLabelItem) ? get_class($abstractFacetTypeLabelItem) : sprintf('%s(%s)', gettype($abstractFacetTypeLabelItem), var_export($abstractFacetTypeLabelItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Label property can only contain items of type \Pixelboxx\StructType\DisplayNameType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Label value
     * @throws \InvalidArgumentException
     * @param \Pixelboxx\StructType\DisplayNameType[] $label
     * @return \Pixelboxx\StructType\AbstractFacetType
     */
    public function setLabel(array $label = array())
    {
        // validation for constraint: array
        if ('' !== ($labelArrayErrorMessage = self::validateLabelForArrayConstraintsFromSetLabel($label))) {
            throw new \InvalidArgumentException($labelArrayErrorMessage, __LINE__);
        }
        $this->Label = $label;
        return $this;
    }
    /**
     * Add item to Label value
     * @throws \InvalidArgumentException
     * @param \Pixelboxx\StructType\DisplayNameType $item
     * @return \Pixelboxx\StructType\AbstractFacetType
     */
    public function addToLabel(\Pixelboxx\StructType\DisplayNameType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \Pixelboxx\StructType\DisplayNameType) {
            throw new \InvalidArgumentException(sprintf('The Label property can only contain items of type \Pixelboxx\StructType\DisplayNameType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Label[] = $item;
        return $this;
    }
    /**
     * Get active value
     * @return bool|null
     */
    public function getActive()
    {
        return $this->active;
    }
    /**
     * Set active value
     * @param bool $active
     * @return \Pixelboxx\StructType\AbstractFacetType
     */
    public function setActive($active = false)
    {
        // validation for constraint: boolean
        if (!is_null($active) && !is_bool($active)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($active, true), gettype($active)), __LINE__);
        }
        $this->active = $active;
        return $this;
    }
}
