<?php

namespace Pixelboxx\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ACAttributeListType StructType
 * Meta information extracted from the WSDL
 * - documentation: Liste von Access Controll Attributen "ACA".
 * @subpackage Structs
 */
class ACAttributeListType extends AbstractStructBase
{
    /**
     * The ACA
     * Meta information extracted from the WSDL
     * - documentation: Typ für ein Access Control Attribut.
     * - base: xs:token
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var string[]
     */
    public $ACA;
    /**
     * Constructor method for ACAttributeListType
     * @uses ACAttributeListType::setACA()
     * @param string[] $aCA
     */
    public function __construct(array $aCA = array())
    {
        $this
            ->setACA($aCA);
    }
    /**
     * Get ACA value
     * @return string[]|null
     */
    public function getACA()
    {
        return $this->ACA;
    }
    /**
     * This method is responsible for validating the values passed to the setACA method
     * This method is willingly generated in order to preserve the one-line inline validation within the setACA method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateACAForArrayConstraintsFromSetACA(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $aCAttributeListTypeACAItem) {
            // validation for constraint: itemType
            if (!is_string($aCAttributeListTypeACAItem)) {
                $invalidValues[] = is_object($aCAttributeListTypeACAItem) ? get_class($aCAttributeListTypeACAItem) : sprintf('%s(%s)', gettype($aCAttributeListTypeACAItem), var_export($aCAttributeListTypeACAItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The ACA property can only contain items of type token, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set ACA value
     * @throws \InvalidArgumentException
     * @param string[] $aCA
     * @return \Pixelboxx\StructType\ACAttributeListType
     */
    public function setACA(array $aCA = array())
    {
        // validation for constraint: array
        if ('' !== ($aCAArrayErrorMessage = self::validateACAForArrayConstraintsFromSetACA($aCA))) {
            throw new \InvalidArgumentException($aCAArrayErrorMessage, __LINE__);
        }
        $this->ACA = $aCA;
        return $this;
    }
    /**
     * Add item to ACA value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \Pixelboxx\StructType\ACAttributeListType
     */
    public function addToACA($item)
    {
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The ACA property can only contain items of type token, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->ACA[] = $item;
        return $this;
    }
}
