<?php

namespace Pixelboxx\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Search ServiceType
 * @subpackage Services
 */
class Search extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named search
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Pixelboxx\StructType\SearchRequest $searchRequest
     * @return \Pixelboxx\StructType\SearchResponse|bool
     */
    public function search(\Pixelboxx\StructType\SearchRequest $searchRequest)
    {
        try {
            $this->setResult($this->getSoapClient()->search($searchRequest));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \Pixelboxx\StructType\SearchResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
