<?php

namespace Pixelboxx\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Rename ServiceType
 * @subpackage Services
 */
class Rename extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named renameFolder
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Pixelboxx\StructType\RenameFolderRequest $renameFolderRequest
     * @return \Pixelboxx\StructType\SuccessMessageResponse|bool
     */
    public function renameFolder(\Pixelboxx\StructType\RenameFolderRequest $renameFolderRequest)
    {
        try {
            $this->setResult($this->getSoapClient()->renameFolder($renameFolderRequest));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \Pixelboxx\StructType\SuccessMessageResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
