<?php

namespace Pixelboxx\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Import ServiceType
 * @subpackage Services
 */
class Import extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named importFile
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Pixelboxx\StructType\ImportFileRequest $importFileRequest
     * @return \Pixelboxx\StructType\ObjectResponse|bool
     */
    public function importFile(\Pixelboxx\StructType\ImportFileRequest $importFileRequest)
    {
        try {
            $this->setResult($this->getSoapClient()->importFile($importFileRequest));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named importFileNewVersion
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Pixelboxx\StructType\ImportFileNewVersionRequest $importFileNewVersionRequest
     * @return \Pixelboxx\StructType\SuccessMessageResponse|bool
     */
    public function importFileNewVersion(\Pixelboxx\StructType\ImportFileNewVersionRequest $importFileNewVersionRequest)
    {
        try {
            $this->setResult($this->getSoapClient()->importFileNewVersion($importFileNewVersionRequest));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \Pixelboxx\StructType\ObjectResponse|\Pixelboxx\StructType\SuccessMessageResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
