<?php

namespace Pixelboxx\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Extended ServiceType
 * @subpackage Services
 */
class Extended extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named extendedSearch
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Pixelboxx\StructType\ExtendedSearchParamType $extendedSearchRequest
     * @return \Pixelboxx\StructType\FolderResponse|bool
     */
    public function extendedSearch(\Pixelboxx\StructType\ExtendedSearchParamType $extendedSearchRequest)
    {
        try {
            $this->setResult($this->getSoapClient()->extendedSearch($extendedSearchRequest));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \Pixelboxx\StructType\FolderResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
