<?php

namespace Pixelboxx\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Delete ServiceType
 * @subpackage Services
 */
class Delete extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named deleteFolder
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Pixelboxx\StructType\DeleteFolderRequest $deleteFolderRequest
     * @return \Pixelboxx\StructType\SuccessMessageResponse|bool
     */
    public function deleteFolder(\Pixelboxx\StructType\DeleteFolderRequest $deleteFolderRequest)
    {
        try {
            $this->setResult($this->getSoapClient()->deleteFolder($deleteFolderRequest));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named deleteObject
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Pixelboxx\StructType\DeleteObjectRequest $deleteObjectRequest
     * @return \Pixelboxx\StructType\SuccessMessageResponse|bool
     */
    public function deleteObject(\Pixelboxx\StructType\DeleteObjectRequest $deleteObjectRequest)
    {
        try {
            $this->setResult($this->getSoapClient()->deleteObject($deleteObjectRequest));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \Pixelboxx\StructType\SuccessMessageResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
