<?php

namespace Pixelboxx\EnumType;

use \WsdlToPhp\PackageBase\AbstractStructEnumBase;

/**
 * This class stands for SearchOpType EnumType
 * Meta information extracted from the WSDL
 * - documentation: Suchoperator. Möglichkeiten sind "eq" (gleich), "neq" (ungleich), "lt" (kleiner), "gt" (größer), "le" (kleiner oder gleich), "ge" (größer oder gleich), "like" (SQL Operator LIKE) und "matches" (case-insensitiv, einfache
 * Wildcards "*" und "?", sind keine Wildcards vorhanden wird ein "*" davor und danach angenommen).
 * @subpackage Enumerations
 */
class SearchOpType extends AbstractStructEnumBase
{
    /**
     * Constant for value 'eq'
     * @return string 'eq'
     */
    const VALUE_EQ = 'eq';
    /**
     * Constant for value 'neq'
     * @return string 'neq'
     */
    const VALUE_NEQ = 'neq';
    /**
     * Constant for value 'lt'
     * @return string 'lt'
     */
    const VALUE_LT = 'lt';
    /**
     * Constant for value 'gt'
     * @return string 'gt'
     */
    const VALUE_GT = 'gt';
    /**
     * Constant for value 'le'
     * @return string 'le'
     */
    const VALUE_LE = 'le';
    /**
     * Constant for value 'ge'
     * @return string 'ge'
     */
    const VALUE_GE = 'ge';
    /**
     * Constant for value 'like'
     * @return string 'like'
     */
    const VALUE_LIKE = 'like';
    /**
     * Constant for value 'matches'
     * @return string 'matches'
     */
    const VALUE_MATCHES = 'matches';
    /**
     * Return allowed values
     * @uses self::VALUE_EQ
     * @uses self::VALUE_NEQ
     * @uses self::VALUE_LT
     * @uses self::VALUE_GT
     * @uses self::VALUE_LE
     * @uses self::VALUE_GE
     * @uses self::VALUE_LIKE
     * @uses self::VALUE_MATCHES
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_EQ,
            self::VALUE_NEQ,
            self::VALUE_LT,
            self::VALUE_GT,
            self::VALUE_LE,
            self::VALUE_GE,
            self::VALUE_LIKE,
            self::VALUE_MATCHES,
        );
    }
}
