<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for MedicionAireEspirado StructType
 * Meta information extracted from the WSDL
 * - documentation: Medicion de la prueba de alcoholemia en aire
 * @subpackage Structs
 */
class MedicionAireEspirado extends AbstractStructBase
{
    /**
     * The alcoholimetro
     * Meta information extracted from the WSDL
     * - documentation: Alcoholimetro utilizado en la prueba de alcoholemia.
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\Alcoholimetro
     */
    public $alcoholimetro;
    /**
     * The medicionToma1
     * Meta information extracted from the WSDL
     * - documentation: Medicion de la primera prueba de alcoholemia en aire.
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\MedicionAlcoholimetro
     */
    public $medicionToma1;
    /**
     * The medicionToma2
     * Meta information extracted from the WSDL
     * - documentation: Medicion de la segunda prueba de alcoholemia en aire.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\MedicionAlcoholimetro
     */
    public $medicionToma2;
    /**
     * Constructor method for MedicionAireEspirado
     * @uses MedicionAireEspirado::setAlcoholimetro()
     * @uses MedicionAireEspirado::setMedicionToma1()
     * @uses MedicionAireEspirado::setMedicionToma2()
     * @param \StructType\Alcoholimetro $alcoholimetro
     * @param \StructType\MedicionAlcoholimetro $medicionToma1
     * @param \StructType\MedicionAlcoholimetro $medicionToma2
     */
    public function __construct(\StructType\Alcoholimetro $alcoholimetro = null, \StructType\MedicionAlcoholimetro $medicionToma1 = null, \StructType\MedicionAlcoholimetro $medicionToma2 = null)
    {
        $this
            ->setAlcoholimetro($alcoholimetro)
            ->setMedicionToma1($medicionToma1)
            ->setMedicionToma2($medicionToma2);
    }
    /**
     * Get alcoholimetro value
     * @return \StructType\Alcoholimetro
     */
    public function getAlcoholimetro()
    {
        return $this->alcoholimetro;
    }
    /**
     * Set alcoholimetro value
     * @param \StructType\Alcoholimetro $alcoholimetro
     * @return \StructType\MedicionAireEspirado
     */
    public function setAlcoholimetro(\StructType\Alcoholimetro $alcoholimetro = null)
    {
        $this->alcoholimetro = $alcoholimetro;
        return $this;
    }
    /**
     * Get medicionToma1 value
     * @return \StructType\MedicionAlcoholimetro
     */
    public function getMedicionToma1()
    {
        return $this->medicionToma1;
    }
    /**
     * Set medicionToma1 value
     * @param \StructType\MedicionAlcoholimetro $medicionToma1
     * @return \StructType\MedicionAireEspirado
     */
    public function setMedicionToma1(\StructType\MedicionAlcoholimetro $medicionToma1 = null)
    {
        $this->medicionToma1 = $medicionToma1;
        return $this;
    }
    /**
     * Get medicionToma2 value
     * @return \StructType\MedicionAlcoholimetro|null
     */
    public function getMedicionToma2()
    {
        return $this->medicionToma2;
    }
    /**
     * Set medicionToma2 value
     * @param \StructType\MedicionAlcoholimetro $medicionToma2
     * @return \StructType\MedicionAireEspirado
     */
    public function setMedicionToma2(\StructType\MedicionAlcoholimetro $medicionToma2 = null)
    {
        $this->medicionToma2 = $medicionToma2;
        return $this;
    }
}
