<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Matricula StructType
 * Meta information extracted from the WSDL
 * - documentation: Matricula del vehiculo.
 * @subpackage Structs
 */
class Matricula extends AbstractStructBase
{
    /**
     * The idMatricula
     * Meta information extracted from the WSDL
     * - documentation: Matricula del vehiculo. Ej: 1010GGG
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $idMatricula;
    /**
     * The extranjera
     * Meta information extracted from the WSDL
     * - documentation: Indicador de si es una matricula extranjera. true si lo es, false en caso contrario.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $extranjera;
    /**
     * The nacionalidad
     * Meta information extracted from the WSDL
     * - documentation: Indica la nacionalidad de la matricula. Se trata de un valor opcional, salvo que se indique que es una matricula extranjera. En caso de no indicarse se tomara como espannola. A=Austria B=Belgica BG=Bulgaria CH=Suiza CY=Chipre
     * CZ=Republica Checa D=Alemania DK=Dinamarca E=Espanna EST=Estonia F=Francia F2=Francia (DPICA) FIN=Finlandia FL=Liechtenstein GB=Reino Unido GBA=Alderney GBG=Guernesey GBJ=Jersey GBM=Isle of Man GBZ=Gibraltar GR=Grecia H=Hungria I=Italia IRL=Irlanda
     * IS=Islandia L=Luxemburgo (autoridad) L2=Luxemburgo (policia) LT=Lituania LV=Latvia M=Malta N=Noruega NA=Antillas Holandesas NL=Holanda P=Portugal PL=Polonia RO=Rumania S=Suecia SK=Eslovaquia SLO=Eslovenia
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $nacionalidad;
    /**
     * Constructor method for Matricula
     * @uses Matricula::setIdMatricula()
     * @uses Matricula::setExtranjera()
     * @uses Matricula::setNacionalidad()
     * @param string $idMatricula
     * @param bool $extranjera
     * @param string $nacionalidad
     */
    public function __construct($idMatricula = null, $extranjera = null, $nacionalidad = null)
    {
        $this
            ->setIdMatricula($idMatricula)
            ->setExtranjera($extranjera)
            ->setNacionalidad($nacionalidad);
    }
    /**
     * Get idMatricula value
     * @return string
     */
    public function getIdMatricula()
    {
        return $this->idMatricula;
    }
    /**
     * Set idMatricula value
     * @param string $idMatricula
     * @return \StructType\Matricula
     */
    public function setIdMatricula($idMatricula = null)
    {
        // validation for constraint: string
        if (!is_null($idMatricula) && !is_string($idMatricula)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($idMatricula, true), gettype($idMatricula)), __LINE__);
        }
        $this->idMatricula = $idMatricula;
        return $this;
    }
    /**
     * Get extranjera value
     * @return bool|null
     */
    public function getExtranjera()
    {
        return $this->extranjera;
    }
    /**
     * Set extranjera value
     * @param bool $extranjera
     * @return \StructType\Matricula
     */
    public function setExtranjera($extranjera = null)
    {
        // validation for constraint: boolean
        if (!is_null($extranjera) && !is_bool($extranjera)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($extranjera, true), gettype($extranjera)), __LINE__);
        }
        $this->extranjera = $extranjera;
        return $this;
    }
    /**
     * Get nacionalidad value
     * @return string|null
     */
    public function getNacionalidad()
    {
        return $this->nacionalidad;
    }
    /**
     * Set nacionalidad value
     * @param string $nacionalidad
     * @return \StructType\Matricula
     */
    public function setNacionalidad($nacionalidad = null)
    {
        // validation for constraint: string
        if (!is_null($nacionalidad) && !is_string($nacionalidad)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($nacionalidad, true), gettype($nacionalidad)), __LINE__);
        }
        $this->nacionalidad = $nacionalidad;
        return $this;
    }
}
