<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for LugarDenunciaUrbana StructType
 * Meta information extracted from the WSDL
 * - documentation: Informacion de un lugar urbano en el que se produce una infraccion
 * @subpackage Structs
 */
class LugarDenunciaUrbana extends AbstractStructBase
{
    /**
     * The calle
     * Meta information extracted from the WSDL
     * - documentation: Nombre de la via del domicilio del denunciado. | Calle de la via urbana en la que se pone la denuncia.Ej: AVDA MADRID 1
     * - base: xsd:string
     * - maxLength: 40
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $calle;
    /**
     * The poblacion
     * Meta information extracted from the WSDL
     * - documentation: Poblacion de la via urbana en la que se pone la denuncia.Ej: GRANADA
     * - base: xsd:string
     * - maxLength: 40
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $poblacion;
    /**
     * The direccion
     * Meta information extracted from the WSDL
     * - documentation: Direccion de la via urbana en la que se pone la denuncia. Ej: CARRETERA JAEN
     * - base: xsd:string
     * - maxLength: 40
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $direccion;
    /**
     * The carril
     * Meta information extracted from the WSDL
     * - documentation: Identificador del carril
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $carril;
    /**
     * Constructor method for LugarDenunciaUrbana
     * @uses LugarDenunciaUrbana::setCalle()
     * @uses LugarDenunciaUrbana::setPoblacion()
     * @uses LugarDenunciaUrbana::setDireccion()
     * @uses LugarDenunciaUrbana::setCarril()
     * @param string $calle
     * @param string $poblacion
     * @param string $direccion
     * @param string $carril
     */
    public function __construct($calle = null, $poblacion = null, $direccion = null, $carril = null)
    {
        $this
            ->setCalle($calle)
            ->setPoblacion($poblacion)
            ->setDireccion($direccion)
            ->setCarril($carril);
    }
    /**
     * Get calle value
     * @return string
     */
    public function getCalle()
    {
        return $this->calle;
    }
    /**
     * Set calle value
     * @param string $calle
     * @return \StructType\LugarDenunciaUrbana
     */
    public function setCalle($calle = null)
    {
        // validation for constraint: string
        if (!is_null($calle) && !is_string($calle)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($calle, true), gettype($calle)), __LINE__);
        }
        // validation for constraint: maxLength(40)
        if (!is_null($calle) && mb_strlen($calle) > 40) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 40', mb_strlen($calle)), __LINE__);
        }
        $this->calle = $calle;
        return $this;
    }
    /**
     * Get poblacion value
     * @return string
     */
    public function getPoblacion()
    {
        return $this->poblacion;
    }
    /**
     * Set poblacion value
     * @param string $poblacion
     * @return \StructType\LugarDenunciaUrbana
     */
    public function setPoblacion($poblacion = null)
    {
        // validation for constraint: string
        if (!is_null($poblacion) && !is_string($poblacion)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($poblacion, true), gettype($poblacion)), __LINE__);
        }
        // validation for constraint: maxLength(40)
        if (!is_null($poblacion) && mb_strlen($poblacion) > 40) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 40', mb_strlen($poblacion)), __LINE__);
        }
        $this->poblacion = $poblacion;
        return $this;
    }
    /**
     * Get direccion value
     * @return string|null
     */
    public function getDireccion()
    {
        return $this->direccion;
    }
    /**
     * Set direccion value
     * @param string $direccion
     * @return \StructType\LugarDenunciaUrbana
     */
    public function setDireccion($direccion = null)
    {
        // validation for constraint: string
        if (!is_null($direccion) && !is_string($direccion)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($direccion, true), gettype($direccion)), __LINE__);
        }
        // validation for constraint: maxLength(40)
        if (!is_null($direccion) && mb_strlen($direccion) > 40) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 40', mb_strlen($direccion)), __LINE__);
        }
        $this->direccion = $direccion;
        return $this;
    }
    /**
     * Get carril value
     * @return string|null
     */
    public function getCarril()
    {
        return $this->carril;
    }
    /**
     * Set carril value
     * @param string $carril
     * @return \StructType\LugarDenunciaUrbana
     */
    public function setCarril($carril = null)
    {
        // validation for constraint: string
        if (!is_null($carril) && !is_string($carril)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($carril, true), gettype($carril)), __LINE__);
        }
        $this->carril = $carril;
        return $this;
    }
}
