<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ATGC StructType
 * @subpackage Structs
 */
class ATGC extends AbstractStructBase
{
    /**
     * The idAgenteATGC
     * Meta information extracted from the WSDL
     * - documentation: Identificador del ATGC. Por ej.T36337G
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $idAgenteATGC;
    /**
     * The unidad
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $unidad;
    /**
     * Constructor method for ATGC
     * @uses ATGC::setIdAgenteATGC()
     * @uses ATGC::setUnidad()
     * @param string $idAgenteATGC
     * @param string $unidad
     */
    public function __construct($idAgenteATGC = null, $unidad = null)
    {
        $this
            ->setIdAgenteATGC($idAgenteATGC)
            ->setUnidad($unidad);
    }
    /**
     * Get idAgenteATGC value
     * @return string
     */
    public function getIdAgenteATGC()
    {
        return $this->idAgenteATGC;
    }
    /**
     * Set idAgenteATGC value
     * @param string $idAgenteATGC
     * @return \StructType\ATGC
     */
    public function setIdAgenteATGC($idAgenteATGC = null)
    {
        // validation for constraint: string
        if (!is_null($idAgenteATGC) && !is_string($idAgenteATGC)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($idAgenteATGC, true), gettype($idAgenteATGC)), __LINE__);
        }
        $this->idAgenteATGC = $idAgenteATGC;
        return $this;
    }
    /**
     * Get unidad value
     * @return string
     */
    public function getUnidad()
    {
        return $this->unidad;
    }
    /**
     * Set unidad value
     * @param string $unidad
     * @return \StructType\ATGC
     */
    public function setUnidad($unidad = null)
    {
        // validation for constraint: string
        if (!is_null($unidad) && !is_string($unidad)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($unidad, true), gettype($unidad)), __LINE__);
        }
        $this->unidad = $unidad;
        return $this;
    }
}
