<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for reservaNumeroDenunciaPeticion StructType
 * Meta information extracted from the WSDL
 * - documentation: Peticion de la operacion de reserva de numero de expediente
 * @subpackage Structs
 */
class ReservaNumeroDenunciaPeticion extends AbstractStructBase
{
    /**
     * The jefatura
     * Meta information extracted from the WSDL
     * - documentation: Identificador de la jefatura.
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $jefatura;
    /**
     * The tipoDenuncia
     * Meta information extracted from the WSDL
     * - documentation: Tipos de denuncia: R para radar, A para estrada, D para el resto.
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $tipoDenuncia;
    /**
     * Constructor method for reservaNumeroDenunciaPeticion
     * @uses ReservaNumeroDenunciaPeticion::setJefatura()
     * @uses ReservaNumeroDenunciaPeticion::setTipoDenuncia()
     * @param string $jefatura
     * @param string $tipoDenuncia
     */
    public function __construct($jefatura = null, $tipoDenuncia = null)
    {
        $this
            ->setJefatura($jefatura)
            ->setTipoDenuncia($tipoDenuncia);
    }
    /**
     * Get jefatura value
     * @return string
     */
    public function getJefatura()
    {
        return $this->jefatura;
    }
    /**
     * Set jefatura value
     * @uses \EnumType\Jefatura::valueIsValid()
     * @uses \EnumType\Jefatura::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $jefatura
     * @return \StructType\ReservaNumeroDenunciaPeticion
     */
    public function setJefatura($jefatura = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\Jefatura::valueIsValid($jefatura)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\Jefatura', is_array($jefatura) ? implode(', ', $jefatura) : var_export($jefatura, true), implode(', ', \EnumType\Jefatura::getValidValues())), __LINE__);
        }
        $this->jefatura = $jefatura;
        return $this;
    }
    /**
     * Get tipoDenuncia value
     * @return string
     */
    public function getTipoDenuncia()
    {
        return $this->tipoDenuncia;
    }
    /**
     * Set tipoDenuncia value
     * @uses \EnumType\TipoDenuncia::valueIsValid()
     * @uses \EnumType\TipoDenuncia::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $tipoDenuncia
     * @return \StructType\ReservaNumeroDenunciaPeticion
     */
    public function setTipoDenuncia($tipoDenuncia = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\TipoDenuncia::valueIsValid($tipoDenuncia)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\TipoDenuncia', is_array($tipoDenuncia) ? implode(', ', $tipoDenuncia) : var_export($tipoDenuncia, true), implode(', ', \EnumType\TipoDenuncia::getValidValues())), __LINE__);
        }
        $this->tipoDenuncia = $tipoDenuncia;
        return $this;
    }
}
