<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PSWSFaultException StructType
 * Meta information extracted from the WSDL
 * - documentation: Excepcion del servicio. Error controlado de cualquiera de las operaciones que ofrece PSWS.
 * @subpackage Structs
 */
class PSWSFaultException extends AbstractStructBase
{
    /**
     * The codigoError
     * Meta information extracted from the WSDL
     * - documentation: Codigo unico que identifica al error que ha sucedido.
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $codigoError;
    /**
     * The descripcion
     * Meta information extracted from the WSDL
     * - documentation: Descripcion detallada del error.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $descripcion;
    /**
     * Constructor method for PSWSFaultException
     * @uses PSWSFaultException::setCodigoError()
     * @uses PSWSFaultException::setDescripcion()
     * @param string $codigoError
     * @param string $descripcion
     */
    public function __construct($codigoError = null, $descripcion = null)
    {
        $this
            ->setCodigoError($codigoError)
            ->setDescripcion($descripcion);
    }
    /**
     * Get codigoError value
     * @return string
     */
    public function getCodigoError()
    {
        return $this->codigoError;
    }
    /**
     * Set codigoError value
     * @param string $codigoError
     * @return \StructType\PSWSFaultException
     */
    public function setCodigoError($codigoError = null)
    {
        // validation for constraint: string
        if (!is_null($codigoError) && !is_string($codigoError)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($codigoError, true), gettype($codigoError)), __LINE__);
        }
        $this->codigoError = $codigoError;
        return $this;
    }
    /**
     * Get descripcion value
     * @return string|null
     */
    public function getDescripcion()
    {
        return $this->descripcion;
    }
    /**
     * Set descripcion value
     * @param string $descripcion
     * @return \StructType\PSWSFaultException
     */
    public function setDescripcion($descripcion = null)
    {
        // validation for constraint: string
        if (!is_null($descripcion) && !is_string($descripcion)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($descripcion, true), gettype($descripcion)), __LINE__);
        }
        $this->descripcion = $descripcion;
        return $this;
    }
}
