<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for numExpediente StructType
 * Meta information extracted from the WSDL
 * - documentation: Numero de expediente desglosado.
 * @subpackage Structs
 */
class NumExpediente extends AbstractStructBase
{
    /**
     * The jefatura
     * Meta information extracted from the WSDL
     * - documentation: Identificador de la jefatura.
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $jefatura;
    /**
     * The numero
     * Meta information extracted from the WSDL
     * - documentation: Numero de expediente, formado por 9 digitos.
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: \d{9}
     * @var string
     */
    public $numero;
    /**
     * The digitoControl
     * Meta information extracted from the WSDL
     * - documentation: Digito de control, formado por 1 digito
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: \d
     * @var string
     */
    public $digitoControl;
    /**
     * Constructor method for numExpediente
     * @uses NumExpediente::setJefatura()
     * @uses NumExpediente::setNumero()
     * @uses NumExpediente::setDigitoControl()
     * @param string $jefatura
     * @param string $numero
     * @param string $digitoControl
     */
    public function __construct($jefatura = null, $numero = null, $digitoControl = null)
    {
        $this
            ->setJefatura($jefatura)
            ->setNumero($numero)
            ->setDigitoControl($digitoControl);
    }
    /**
     * Get jefatura value
     * @return string
     */
    public function getJefatura()
    {
        return $this->jefatura;
    }
    /**
     * Set jefatura value
     * @uses \EnumType\Jefatura::valueIsValid()
     * @uses \EnumType\Jefatura::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $jefatura
     * @return \StructType\NumExpediente
     */
    public function setJefatura($jefatura = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\Jefatura::valueIsValid($jefatura)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\Jefatura', is_array($jefatura) ? implode(', ', $jefatura) : var_export($jefatura, true), implode(', ', \EnumType\Jefatura::getValidValues())), __LINE__);
        }
        $this->jefatura = $jefatura;
        return $this;
    }
    /**
     * Get numero value
     * @return string
     */
    public function getNumero()
    {
        return $this->numero;
    }
    /**
     * Set numero value
     * @param string $numero
     * @return \StructType\NumExpediente
     */
    public function setNumero($numero = null)
    {
        // validation for constraint: string
        if (!is_null($numero) && !is_string($numero)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($numero, true), gettype($numero)), __LINE__);
        }
        // validation for constraint: pattern(\d{9})
        if (!is_null($numero) && !preg_match('/\\d{9}/', $numero)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression \d{9}', var_export($numero, true)), __LINE__);
        }
        $this->numero = $numero;
        return $this;
    }
    /**
     * Get digitoControl value
     * @return string
     */
    public function getDigitoControl()
    {
        return $this->digitoControl;
    }
    /**
     * Set digitoControl value
     * @param string $digitoControl
     * @return \StructType\NumExpediente
     */
    public function setDigitoControl($digitoControl = null)
    {
        // validation for constraint: string
        if (!is_null($digitoControl) && !is_string($digitoControl)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($digitoControl, true), gettype($digitoControl)), __LINE__);
        }
        // validation for constraint: pattern(\d)
        if (!is_null($digitoControl) && !preg_match('/\\d/', $digitoControl)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression \d', var_export($digitoControl, true)), __LINE__);
        }
        $this->digitoControl = $digitoControl;
        return $this;
    }
}
