<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for MedicionSangre StructType
 * Meta information extracted from the WSDL
 * - documentation: Medicion de la prueba de alcoholemia en sangre
 * @subpackage Structs
 */
class MedicionSangre extends AbstractStructBase
{
    /**
     * The valor
     * Meta information extracted from the WSDL
     * - documentation: Valor de la infraccion de alcoholemia cuando la prueba se ha realizado por medicion en sangre.
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $valor;
    /**
     * Constructor method for MedicionSangre
     * @uses MedicionSangre::setValor()
     * @param float $valor
     */
    public function __construct($valor = null)
    {
        $this
            ->setValor($valor);
    }
    /**
     * Get valor value
     * @return float
     */
    public function getValor()
    {
        return $this->valor;
    }
    /**
     * Set valor value
     * @param float $valor
     * @return \StructType\MedicionSangre
     */
    public function setValor($valor = null)
    {
        // validation for constraint: float
        if (!is_null($valor) && !(is_float($valor) || is_numeric($valor))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($valor, true), gettype($valor)), __LINE__);
        }
        $this->valor = $valor;
        return $this;
    }
}
