<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for HechoCatalogado StructType
 * Meta information extracted from the WSDL
 * - documentation: Informa del hecho catalogado, aqui se encuentra la opcion que complementa la catalogacion del precepto.
 * @subpackage Structs
 */
class HechoCatalogado extends AbstractStructBase
{
    /**
     * The opcion
     * Meta information extracted from the WSDL
     * - documentation: Opcion de la catalogacion del precepto. Ej: 5A
     * - base: xsd:string
     * - maxLength: 2
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $opcion;
    /**
     * Constructor method for HechoCatalogado
     * @uses HechoCatalogado::setOpcion()
     * @param string $opcion
     */
    public function __construct($opcion = null)
    {
        $this
            ->setOpcion($opcion);
    }
    /**
     * Get opcion value
     * @return string
     */
    public function getOpcion()
    {
        return $this->opcion;
    }
    /**
     * Set opcion value
     * @param string $opcion
     * @return \StructType\HechoCatalogado
     */
    public function setOpcion($opcion = null)
    {
        // validation for constraint: string
        if (!is_null($opcion) && !is_string($opcion)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($opcion, true), gettype($opcion)), __LINE__);
        }
        // validation for constraint: maxLength(2)
        if (!is_null($opcion) && mb_strlen($opcion) > 2) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 2', mb_strlen($opcion)), __LINE__);
        }
        $this->opcion = $opcion;
        return $this;
    }
}
