<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for esValidoCertificadoCinemometroPeticion StructType
 * Meta information extracted from the WSDL
 * - documentation: Peticion de la operacion de validar un cinemometro
 * @subpackage Structs
 */
class EsValidoCertificadoCinemometroPeticion extends AbstractStructBase
{
    /**
     * The cin_id
     * Meta information extracted from the WSDL
     * - documentation: Identificador del cinemometro cuya validez se desea consultar. Ej: 2990
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $cin_id;
    /**
     * The fecha_denuncia
     * Meta information extracted from the WSDL
     * - documentation: Fecha en la cual se desea conocer la validez del cinemometro. Ej: 2013-10-31
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $fecha_denuncia;
    /**
     * Constructor method for esValidoCertificadoCinemometroPeticion
     * @uses EsValidoCertificadoCinemometroPeticion::setCin_id()
     * @uses EsValidoCertificadoCinemometroPeticion::setFecha_denuncia()
     * @param string $cin_id
     * @param string $fecha_denuncia
     */
    public function __construct($cin_id = null, $fecha_denuncia = null)
    {
        $this
            ->setCin_id($cin_id)
            ->setFecha_denuncia($fecha_denuncia);
    }
    /**
     * Get cin_id value
     * @return string
     */
    public function getCin_id()
    {
        return $this->cin_id;
    }
    /**
     * Set cin_id value
     * @param string $cin_id
     * @return \StructType\EsValidoCertificadoCinemometroPeticion
     */
    public function setCin_id($cin_id = null)
    {
        // validation for constraint: string
        if (!is_null($cin_id) && !is_string($cin_id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cin_id, true), gettype($cin_id)), __LINE__);
        }
        $this->cin_id = $cin_id;
        return $this;
    }
    /**
     * Get fecha_denuncia value
     * @return string
     */
    public function getFecha_denuncia()
    {
        return $this->fecha_denuncia;
    }
    /**
     * Set fecha_denuncia value
     * @param string $fecha_denuncia
     * @return \StructType\EsValidoCertificadoCinemometroPeticion
     */
    public function setFecha_denuncia($fecha_denuncia = null)
    {
        // validation for constraint: string
        if (!is_null($fecha_denuncia) && !is_string($fecha_denuncia)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($fecha_denuncia, true), gettype($fecha_denuncia)), __LINE__);
        }
        $this->fecha_denuncia = $fecha_denuncia;
        return $this;
    }
}
