<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DocumentoVelocidad StructType
 * Meta information extracted from the WSDL
 * - documentation: Documentacion asociada a un expediente de velocidad en su informacion de velocidad
 * @subpackage Structs
 */
class DocumentoVelocidad extends AbstractStructBase
{
    /**
     * The contenido
     * Meta information extracted from the WSDL
     * - documentation: Contenido en bytes del documento.
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $contenido;
    /**
     * The formato
     * Meta information extracted from the WSDL
     * - documentation: Extension del fichero a adjuntar:pdf, gif, tif, etc
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $formato;
    /**
     * The tipo
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $tipo;
    /**
     * Constructor method for DocumentoVelocidad
     * @uses DocumentoVelocidad::setContenido()
     * @uses DocumentoVelocidad::setFormato()
     * @uses DocumentoVelocidad::setTipo()
     * @param string $contenido
     * @param string $formato
     * @param string $tipo
     */
    public function __construct($contenido = null, $formato = null, $tipo = null)
    {
        $this
            ->setContenido($contenido)
            ->setFormato($formato)
            ->setTipo($tipo);
    }
    /**
     * Get contenido value
     * @return string
     */
    public function getContenido()
    {
        return $this->contenido;
    }
    /**
     * Set contenido value
     * @param string $contenido
     * @return \StructType\DocumentoVelocidad
     */
    public function setContenido($contenido = null)
    {
        // validation for constraint: string
        if (!is_null($contenido) && !is_string($contenido)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($contenido, true), gettype($contenido)), __LINE__);
        }
        $this->contenido = $contenido;
        return $this;
    }
    /**
     * Get formato value
     * @return string
     */
    public function getFormato()
    {
        return $this->formato;
    }
    /**
     * Set formato value
     * @param string $formato
     * @return \StructType\DocumentoVelocidad
     */
    public function setFormato($formato = null)
    {
        // validation for constraint: string
        if (!is_null($formato) && !is_string($formato)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($formato, true), gettype($formato)), __LINE__);
        }
        $this->formato = $formato;
        return $this;
    }
    /**
     * Get tipo value
     * @return string|null
     */
    public function getTipo()
    {
        return $this->tipo;
    }
    /**
     * Set tipo value
     * @uses \EnumType\Tipo::valueIsValid()
     * @uses \EnumType\Tipo::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $tipo
     * @return \StructType\DocumentoVelocidad
     */
    public function setTipo($tipo = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\Tipo::valueIsValid($tipo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\Tipo', is_array($tipo) ? implode(', ', $tipo) : var_export($tipo, true), implode(', ', \EnumType\Tipo::getValidValues())), __LINE__);
        }
        $this->tipo = $tipo;
        return $this;
    }
}
