<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Documento StructType
 * Meta information extracted from the WSDL
 * - documentation: Documentacion asociada a un expediente
 * @subpackage Structs
 */
class Documento extends AbstractStructBase
{
    /**
     * The contenido
     * Meta information extracted from the WSDL
     * - documentation: Contenido en bytes del documento.
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $contenido;
    /**
     * The tipo
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $tipo;
    /**
     * The formato
     * Meta information extracted from the WSDL
     * - documentation: Extension del fichero a adjuntar:pdf, gif, tif, etc
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $formato;
    /**
     * Constructor method for Documento
     * @uses Documento::setContenido()
     * @uses Documento::setTipo()
     * @uses Documento::setFormato()
     * @param string $contenido
     * @param string $tipo
     * @param string $formato
     */
    public function __construct($contenido = null, $tipo = null, $formato = null)
    {
        $this
            ->setContenido($contenido)
            ->setTipo($tipo)
            ->setFormato($formato);
    }
    /**
     * Get contenido value
     * @return string
     */
    public function getContenido()
    {
        return $this->contenido;
    }
    /**
     * Set contenido value
     * @param string $contenido
     * @return \StructType\Documento
     */
    public function setContenido($contenido = null)
    {
        // validation for constraint: string
        if (!is_null($contenido) && !is_string($contenido)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($contenido, true), gettype($contenido)), __LINE__);
        }
        $this->contenido = $contenido;
        return $this;
    }
    /**
     * Get tipo value
     * @return string
     */
    public function getTipo()
    {
        return $this->tipo;
    }
    /**
     * Set tipo value
     * @uses \EnumType\Tipo::valueIsValid()
     * @uses \EnumType\Tipo::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $tipo
     * @return \StructType\Documento
     */
    public function setTipo($tipo = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\Tipo::valueIsValid($tipo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\Tipo', is_array($tipo) ? implode(', ', $tipo) : var_export($tipo, true), implode(', ', \EnumType\Tipo::getValidValues())), __LINE__);
        }
        $this->tipo = $tipo;
        return $this;
    }
    /**
     * Get formato value
     * @return string
     */
    public function getFormato()
    {
        return $this->formato;
    }
    /**
     * Set formato value
     * @param string $formato
     * @return \StructType\Documento
     */
    public function setFormato($formato = null)
    {
        // validation for constraint: string
        if (!is_null($formato) && !is_string($formato)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($formato, true), gettype($formato)), __LINE__);
        }
        $this->formato = $formato;
        return $this;
    }
}
