<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CodigoPrecepto StructType
 * Meta information extracted from the WSDL
 * - documentation: Codificacion de precepto infringido
 * @subpackage Structs
 */
class CodigoPrecepto extends AbstractStructBase
{
    /**
     * The normativa
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $normativa;
    /**
     * The articulo
     * Meta information extracted from the WSDL
     * - documentation: Articulo de la catalogacion del precepto infringido. Ej: 030
     * - base: xsd:int
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: \d{1,3}
     * @var int
     */
    public $articulo;
    /**
     * The apartado
     * Meta information extracted from the WSDL
     * - documentation: Apartado de la catalogacion del precepto infringido.
     * - base: xsd:string
     * - maxLength: 1
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $apartado;
    /**
     * The inciso
     * Meta information extracted from the WSDL
     * - documentation: Inciso de la catalogacion del precepto infringido.
     * - base: xsd:string
     * - maxLength: 1
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $inciso;
    /**
     * Constructor method for CodigoPrecepto
     * @uses CodigoPrecepto::setNormativa()
     * @uses CodigoPrecepto::setArticulo()
     * @uses CodigoPrecepto::setApartado()
     * @uses CodigoPrecepto::setInciso()
     * @param string $normativa
     * @param int $articulo
     * @param string $apartado
     * @param string $inciso
     */
    public function __construct($normativa = null, $articulo = null, $apartado = null, $inciso = null)
    {
        $this
            ->setNormativa($normativa)
            ->setArticulo($articulo)
            ->setApartado($apartado)
            ->setInciso($inciso);
    }
    /**
     * Get normativa value
     * @return string
     */
    public function getNormativa()
    {
        return $this->normativa;
    }
    /**
     * Set normativa value
     * @uses \EnumType\Normativa::valueIsValid()
     * @uses \EnumType\Normativa::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $normativa
     * @return \StructType\CodigoPrecepto
     */
    public function setNormativa($normativa = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\Normativa::valueIsValid($normativa)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\Normativa', is_array($normativa) ? implode(', ', $normativa) : var_export($normativa, true), implode(', ', \EnumType\Normativa::getValidValues())), __LINE__);
        }
        $this->normativa = $normativa;
        return $this;
    }
    /**
     * Get articulo value
     * @return int
     */
    public function getArticulo()
    {
        return $this->articulo;
    }
    /**
     * Set articulo value
     * @param int $articulo
     * @return \StructType\CodigoPrecepto
     */
    public function setArticulo($articulo = null)
    {
        // validation for constraint: int
        if (!is_null($articulo) && !(is_int($articulo) || ctype_digit($articulo))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($articulo, true), gettype($articulo)), __LINE__);
        }
        // validation for constraint: pattern(\d{1,3})
        if (!is_null($articulo) && !preg_match('/\\d{1,3}/', $articulo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression \d{1,3}', var_export($articulo, true)), __LINE__);
        }
        $this->articulo = $articulo;
        return $this;
    }
    /**
     * Get apartado value
     * @return string|null
     */
    public function getApartado()
    {
        return $this->apartado;
    }
    /**
     * Set apartado value
     * @param string $apartado
     * @return \StructType\CodigoPrecepto
     */
    public function setApartado($apartado = null)
    {
        // validation for constraint: string
        if (!is_null($apartado) && !is_string($apartado)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($apartado, true), gettype($apartado)), __LINE__);
        }
        // validation for constraint: maxLength(1)
        if (!is_null($apartado) && mb_strlen($apartado) > 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 1', mb_strlen($apartado)), __LINE__);
        }
        $this->apartado = $apartado;
        return $this;
    }
    /**
     * Get inciso value
     * @return string|null
     */
    public function getInciso()
    {
        return $this->inciso;
    }
    /**
     * Set inciso value
     * @param string $inciso
     * @return \StructType\CodigoPrecepto
     */
    public function setInciso($inciso = null)
    {
        // validation for constraint: string
        if (!is_null($inciso) && !is_string($inciso)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($inciso, true), gettype($inciso)), __LINE__);
        }
        // validation for constraint: maxLength(1)
        if (!is_null($inciso) && mb_strlen($inciso) > 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 1', mb_strlen($inciso)), __LINE__);
        }
        $this->inciso = $inciso;
        return $this;
    }
}
