<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AparatoMedida StructType
 * Meta information extracted from the WSDL
 * - documentation: En caso de sanciones de velocidad, deberia indicarse obligatoriamente o bien la informacion del cinemometro o bien que se trata de una denuncia de tacografo.
 * @subpackage Structs
 */
class AparatoMedida extends AbstractStructBase
{
    /**
     * The cinemometro
     * Meta information extracted from the WSDL
     * - documentation: Contiene la informacion del cinemometro.
     * - choice: cinemometro | tacografo
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Cinemometro
     */
    public $cinemometro;
    /**
     * The tacografo
     * Meta information extracted from the WSDL
     * - documentation: Indicador de si la sancion de velocidad es de tacografo.
     * - choice: cinemometro | tacografo
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $tacografo;
    /**
     * Constructor method for AparatoMedida
     * @uses AparatoMedida::setCinemometro()
     * @uses AparatoMedida::setTacografo()
     * @param \StructType\Cinemometro $cinemometro
     * @param string $tacografo
     */
    public function __construct(\StructType\Cinemometro $cinemometro = null, $tacografo = null)
    {
        $this
            ->setCinemometro($cinemometro)
            ->setTacografo($tacografo);
    }
    /**
     * Get cinemometro value
     * @return \StructType\Cinemometro|null
     */
    public function getCinemometro()
    {
        return isset($this->cinemometro) ? $this->cinemometro : null;
    }
    /**
     * This method is responsible for validating the value passed to the setCinemometro method
     * This method is willingly generated in order to preserve the one-line inline validation within the setCinemometro method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateCinemometroForChoiceConstraintsFromSetCinemometro($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'tacografo',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property cinemometro can\'t be set as the property %s is already set. Only one property must be set among these properties: cinemometro, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set cinemometro value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\Cinemometro $cinemometro
     * @return \StructType\AparatoMedida
     */
    public function setCinemometro(\StructType\Cinemometro $cinemometro = null)
    {
        // validation for constraint: choice(cinemometro, tacografo)
        if ('' !== ($cinemometroChoiceErrorMessage = self::validateCinemometroForChoiceConstraintsFromSetCinemometro($cinemometro))) {
            throw new \InvalidArgumentException($cinemometroChoiceErrorMessage, __LINE__);
        }
        if (is_null($cinemometro) || (is_array($cinemometro) && empty($cinemometro))) {
            unset($this->cinemometro);
        } else {
            $this->cinemometro = $cinemometro;
        }
        return $this;
    }
    /**
     * Get tacografo value
     * @return string|null
     */
    public function getTacografo()
    {
        return isset($this->tacografo) ? $this->tacografo : null;
    }
    /**
     * This method is responsible for validating the value passed to the setTacografo method
     * This method is willingly generated in order to preserve the one-line inline validation within the setTacografo method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateTacografoForChoiceConstraintsFromSetTacografo($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'cinemometro',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property tacografo can\'t be set as the property %s is already set. Only one property must be set among these properties: tacografo, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set tacografo value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param string $tacografo
     * @return \StructType\AparatoMedida
     */
    public function setTacografo($tacografo = null)
    {
        // validation for constraint: string
        if (!is_null($tacografo) && !is_string($tacografo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($tacografo, true), gettype($tacografo)), __LINE__);
        }
        // validation for constraint: choice(cinemometro, tacografo)
        if ('' !== ($tacografoChoiceErrorMessage = self::validateTacografoForChoiceConstraintsFromSetTacografo($tacografo))) {
            throw new \InvalidArgumentException($tacografoChoiceErrorMessage, __LINE__);
        }
        if (is_null($tacografo) || (is_array($tacografo) && empty($tacografo))) {
            unset($this->tacografo);
        } else {
            $this->tacografo = $tacografo;
        }
        return $this;
    }
}
