<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for altaDenunciaPeticion StructType
 * Meta information extracted from the WSDL
 * - documentation: Peticion de la operacion de alta de expediente.
 * @subpackage Structs
 */
class AltaDenunciaPeticion extends AbstractStructBase
{
    /**
     * The expediente
     * Meta information extracted from the WSDL
     * - documentation: Informacion del expediente a dar de alta.
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\Expediente
     */
    public $expediente;
    /**
     * The numExpediente
     * Meta information extracted from the WSDL
     * - documentation: Numero de expediente a dar de alta y que ha sido reservado previamente.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\NumExpediente
     */
    public $numExpediente;
    /**
     * Constructor method for altaDenunciaPeticion
     * @uses AltaDenunciaPeticion::setExpediente()
     * @uses AltaDenunciaPeticion::setNumExpediente()
     * @param \StructType\Expediente $expediente
     * @param \StructType\NumExpediente $numExpediente
     */
    public function __construct(\StructType\Expediente $expediente = null, \StructType\NumExpediente $numExpediente = null)
    {
        $this
            ->setExpediente($expediente)
            ->setNumExpediente($numExpediente);
    }
    /**
     * Get expediente value
     * @return \StructType\Expediente
     */
    public function getExpediente()
    {
        return $this->expediente;
    }
    /**
     * Set expediente value
     * @param \StructType\Expediente $expediente
     * @return \StructType\AltaDenunciaPeticion
     */
    public function setExpediente(\StructType\Expediente $expediente = null)
    {
        $this->expediente = $expediente;
        return $this;
    }
    /**
     * Get numExpediente value
     * @return \StructType\NumExpediente|null
     */
    public function getNumExpediente()
    {
        return $this->numExpediente;
    }
    /**
     * Set numExpediente value
     * @param \StructType\NumExpediente $numExpediente
     * @return \StructType\AltaDenunciaPeticion
     */
    public function setNumExpediente(\StructType\NumExpediente $numExpediente = null)
    {
        $this->numExpediente = $numExpediente;
        return $this;
    }
}
