<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Existe ServiceType
 * @subpackage Services
 */
class Existe extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named existeCinemometro
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ExisteCinemometroPeticion $existeCinemometroPeticion
     * @return \StructType\ExisteCinemometroRespuesta|bool
     */
    public function existeCinemometro(\StructType\ExisteCinemometroPeticion $existeCinemometroPeticion)
    {
        try {
            $this->setResult($this->getSoapClient()->existeCinemometro($existeCinemometroPeticion));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named existeExpediente
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ExisteExpedientePeticion $existeExpedientePeticion
     * @return \StructType\ExisteExpedienteRespuesta|bool
     */
    public function existeExpediente(\StructType\ExisteExpedientePeticion $existeExpedientePeticion)
    {
        try {
            $this->setResult($this->getSoapClient()->existeExpediente($existeExpedientePeticion));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\ExisteCinemometroRespuesta|\StructType\ExisteExpedienteRespuesta
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
