<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Adjuntar ServiceType
 * @subpackage Services
 */
class Adjuntar extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named adjuntarDocumento
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\AdjuntarDocumentoPeticion $adjuntarDocumentoPeticion
     * @return \StructType\AdjuntarDocumentoRespuesta|bool
     */
    public function adjuntarDocumento(\StructType\AdjuntarDocumentoPeticion $adjuntarDocumentoPeticion)
    {
        try {
            $this->setResult($this->getSoapClient()->adjuntarDocumento($adjuntarDocumentoPeticion));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\AdjuntarDocumentoRespuesta
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
