<?php

namespace EnumType;

use \WsdlToPhp\PackageBase\AbstractStructEnumBase;

/**
 * This class stands for normativa EnumType
 * Meta information extracted from the WSDL
 * - documentation: Normativa de la catalogacion del precepto infringido. Los valores posibles son: CIR=Rgto.Gral. de Circulacion CON=Rgto.Gral. Conductores CRC=Centros de Recon. Conductores EPC=Escuelas Particulares de Conductores LSV=Ley de Seguridad
 * Vial SOA=Seguro Obligatorio Automoviles VEH=Rgto. Gral. de Vehiculos
 * @subpackage Enumerations
 */
class Normativa extends AbstractStructEnumBase
{
    /**
     * Constant for value 'CIR'
     * @return string 'CIR'
     */
    const VALUE_CIR = 'CIR';
    /**
     * Constant for value 'CON'
     * @return string 'CON'
     */
    const VALUE_CON = 'CON';
    /**
     * Constant for value 'CRC'
     * @return string 'CRC'
     */
    const VALUE_CRC = 'CRC';
    /**
     * Constant for value 'EPC'
     * @return string 'EPC'
     */
    const VALUE_EPC = 'EPC';
    /**
     * Constant for value 'LSV'
     * @return string 'LSV'
     */
    const VALUE_LSV = 'LSV';
    /**
     * Constant for value 'SOA'
     * @return string 'SOA'
     */
    const VALUE_SOA = 'SOA';
    /**
     * Constant for value 'VEH'
     * @return string 'VEH'
     */
    const VALUE_VEH = 'VEH';
    /**
     * Return allowed values
     * @uses self::VALUE_CIR
     * @uses self::VALUE_CON
     * @uses self::VALUE_CRC
     * @uses self::VALUE_EPC
     * @uses self::VALUE_LSV
     * @uses self::VALUE_SOA
     * @uses self::VALUE_VEH
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_CIR,
            self::VALUE_CON,
            self::VALUE_CRC,
            self::VALUE_EPC,
            self::VALUE_LSV,
            self::VALUE_SOA,
            self::VALUE_VEH,
        );
    }
}
