<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for MedicionAlcoholimetro StructType
 * Meta information extracted from the WSDL
 * - documentation: Datos de una medicion de alcoholemia
 * @subpackage Structs
 */
class MedicionAlcoholimetro extends AbstractStructBase
{
    /**
     * The hora
     * Meta information extracted from the WSDL
     * - documentation: Hora en la que se realiza la prueba de alcoholemia. Ej: 01:00:00
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $hora;
    /**
     * The valor
     * Meta information extracted from the WSDL
     * - documentation: Valor de la tasa de la prueba de alcoholemia en aire. EJ: 1.02
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $valor;
    /**
     * Constructor method for MedicionAlcoholimetro
     * @uses MedicionAlcoholimetro::setHora()
     * @uses MedicionAlcoholimetro::setValor()
     * @param string $hora
     * @param float $valor
     */
    public function __construct($hora = null, $valor = null)
    {
        $this
            ->setHora($hora)
            ->setValor($valor);
    }
    /**
     * Get hora value
     * @return string
     */
    public function getHora()
    {
        return $this->hora;
    }
    /**
     * Set hora value
     * @param string $hora
     * @return \StructType\MedicionAlcoholimetro
     */
    public function setHora($hora = null)
    {
        // validation for constraint: string
        if (!is_null($hora) && !is_string($hora)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($hora, true), gettype($hora)), __LINE__);
        }
        $this->hora = $hora;
        return $this;
    }
    /**
     * Get valor value
     * @return float
     */
    public function getValor()
    {
        return $this->valor;
    }
    /**
     * Set valor value
     * @param float $valor
     * @return \StructType\MedicionAlcoholimetro
     */
    public function setValor($valor = null)
    {
        // validation for constraint: float
        if (!is_null($valor) && !(is_float($valor) || is_numeric($valor))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($valor, true), gettype($valor)), __LINE__);
        }
        $this->valor = $valor;
        return $this;
    }
}
